/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValueNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public final class LLVMTypeIdForExceptionNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMExpressionNode thrownTypeID;
    @Node.Child
    private ToComparableValue toComparableValue;

    public LLVMTypeIdForExceptionNode(LLVMExpressionNode thrownTypeID) {
        this.thrownTypeID = thrownTypeID;
        this.toComparableValue = ToComparableValueNodeGen.create();
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        try {
            LLVMPointer pointer = this.thrownTypeID.executeLLVMPointer(frame);
            return (int)this.toComparableValue.executeWithTarget(pointer);
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(e);
        }
    }
}

