/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMExitException;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public class LLVMGlobalRootNode
extends RootNode {
    private final DirectCallNode startFunction;
    private final int mainFunctionType;
    private final String applicationPath;
    private final LLVMFunctionDescriptor mainFunctionDesc;

    public LLVMGlobalRootNode(LLVMLanguage language, FrameDescriptor descriptor, LLVMFunctionDescriptor mainFunctionDescriptor, CallTarget startFunction, String applicationPath) {
        super((TruffleLanguage)language, descriptor);
        this.startFunction = Truffle.getRuntime().createDirectCallNode(startFunction);
        this.mainFunctionType = LLVMGlobalRootNode.getMainFunctionType(mainFunctionDescriptor);
        this.mainFunctionDesc = mainFunctionDescriptor;
        this.applicationPath = applicationPath;
    }

    public boolean isInternal() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        return this.executeWithoutFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object executeWithoutFrame() {
        try (LLVMStack.StackPointer basePointer = this.getContext().getThreadingStack().getStack().newFrame();){
            try {
                LLVMArgumentBuffer appPath = new LLVMArgumentBuffer(this.applicationPath);
                LLVMManagedPointer applicationPathObj = LLVMManagedPointer.create(LLVMTypedForeignObject.createUnknown(appPath));
                Object[] realArgs = new Object[]{basePointer, this.mainFunctionType, applicationPathObj, LLVMManagedPointer.create(this.mainFunctionDesc)};
                Object result = this.startFunction.call(realArgs);
                this.getContext().awaitThreadTermination();
                Integer n = (int)((Integer)result);
                this.getContext().shutdownThreads();
                return n;
            }
            catch (LLVMExitException e) {
                try {
                    LLVMContext context = this.getContext();
                    context.setCleanupNecessary(false);
                    context.awaitThreadTermination();
                    Integer n = e.getExitStatus();
                    this.getContext().shutdownThreads();
                    if (basePointer != null) {
                        basePointer.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    this.getContext().shutdownThreads();
                    throw throwable;
                }
            }
        }
    }

    private static int getMainFunctionType(LLVMFunctionDescriptor mainFunctionDescriptor) {
        CompilerAsserts.neverPartOfCompilation();
        Type returnType = mainFunctionDescriptor.getType().getReturnType();
        Type[] argumentTypes = mainFunctionDescriptor.getType().getArgumentTypes();
        if (argumentTypes.length > 0 && argumentTypes[0] instanceof PrimitiveType && ((PrimitiveType)argumentTypes[0]).getPrimitiveKind() == PrimitiveType.PrimitiveKind.I64) {
            return 1;
        }
        if (returnType instanceof VoidType) {
            return 2;
        }
        if (returnType instanceof PrimitiveType) {
            switch (((PrimitiveType)returnType).getPrimitiveKind()) {
                case I8: {
                    return 3;
                }
                case I16: {
                    return 4;
                }
                case I32: {
                    return 0;
                }
                case I64: {
                    return 5;
                }
            }
        }
        throw new AssertionError((Object)"Unexpected main method signature");
    }

    public final LLVMContext getContext() {
        return (LLVMContext)this.lookupContextReference(LLVMLanguage.class).get();
    }
}

