/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import java.util.HashMap;
import java.util.Map;

public class LLVMFunctionStartNode
extends RootNode
implements LLVMHasDatalayoutNode {
    @Node.Child
    private LLVMExpressionNode node;
    private final String name;
    private final int explicitArgumentsCount;
    private final DebugInformation debugInformation;
    private final DataLayout dataLayout;

    public LLVMFunctionStartNode(LLVMLanguage language, LLVMExpressionNode node, FrameDescriptor frameDescriptor, String name, int explicitArgumentsCount, String originalName, Source bcSource, LLVMSourceLocation location, DataLayout dataLayout) {
        super((TruffleLanguage)language, frameDescriptor);
        this.dataLayout = dataLayout;
        this.debugInformation = new DebugInformation(originalName, bcSource, location);
        this.explicitArgumentsCount = explicitArgumentsCount;
        this.node = node;
        this.name = name;
    }

    public SourceSection getSourceSection() {
        return this.debugInformation.sourceLocation.getSourceSection();
    }

    public boolean isInternal() {
        return this.debugInformation.bcSource.isInternal();
    }

    public Object execute(VirtualFrame frame) {
        Object result = this.node.executeGeneric(frame);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.debugInformation.originalName != null) {
            return this.debugInformation.originalName;
        }
        return this.name;
    }

    public int getExplicitArgumentsCount() {
        return this.explicitArgumentsCount;
    }

    public String getOriginalName() {
        return this.debugInformation.originalName;
    }

    public String getBcName() {
        return this.name;
    }

    public Source getBcSource() {
        return this.debugInformation.bcSource;
    }

    @Override
    public DataLayout getDatalayout() {
        return this.dataLayout;
    }

    @CompilerDirectives.TruffleBoundary
    public Map<String, Object> getDebugProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.debugInformation.originalName != null) {
            properties.put("originalName", this.debugInformation.originalName);
        }
        if (this.debugInformation.bcSource != null) {
            properties.put("bcSource", this.debugInformation.bcSource);
        }
        if (this.debugInformation.sourceLocation != null) {
            properties.put("sourceLocation", this.debugInformation.sourceLocation);
        }
        return properties;
    }

    private static final class DebugInformation {
        private final String originalName;
        private final Source bcSource;
        private final LLVMSourceLocation sourceLocation;

        DebugInformation(String originalName, Source bcSource, LLVMSourceLocation sourceLocation) {
            this.originalName = originalName;
            this.bcSource = bcSource;
            this.sourceLocation = sourceLocation;
        }
    }
}

