/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMDispatchNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMLookupDispatchTargetNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMPrepareArgumentNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMPrepareArgumentNodeGen;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public final class LLVMCallNode
extends LLVMExpressionNode {
    public static final int USER_ARGUMENT_OFFSET = 1;
    @Node.Children
    private final LLVMExpressionNode[] argumentNodes;
    @Node.Children
    private final LLVMPrepareArgumentNode[] prepareArgumentNodes;
    @Node.Child
    private LLVMLookupDispatchTargetNode dispatchTargetNode;
    @Node.Child
    private LLVMDispatchNode dispatchNode;
    private final boolean isSourceCall;

    public LLVMCallNode(FunctionType functionType, LLVMExpressionNode functionNode, LLVMExpressionNode[] argumentNodes, boolean isSourceCall) {
        this.argumentNodes = argumentNodes;
        this.prepareArgumentNodes = LLVMCallNode.createPrepareArgumentNodes(argumentNodes);
        this.dispatchTargetNode = LLVMLookupDispatchTargetNodeGen.create(functionNode);
        this.dispatchNode = LLVMDispatchNodeGen.create(functionType);
        this.isSourceCall = isSourceCall;
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object function = this.dispatchTargetNode.executeGeneric(frame);
        Object[] argValues = new Object[this.argumentNodes.length];
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            argValues[i] = this.prepareArgumentNodes[i].executeWithTarget(this.argumentNodes[i].executeGeneric(frame));
        }
        return this.dispatchNode.executeDispatch(function, argValues);
    }

    private static LLVMPrepareArgumentNode[] createPrepareArgumentNodes(LLVMExpressionNode[] argumentNodes) {
        LLVMPrepareArgumentNode[] nodes = new LLVMPrepareArgumentNode[argumentNodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = LLVMPrepareArgumentNodeGen.create();
        }
        return nodes;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.CallTag.class) {
            return this.isSourceCall && this.getSourceLocation() != null;
        }
        return super.hasTag(tag);
    }
}

