/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.factories;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMDataEscapeNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.nodes.factories.LLVMObjectAccessFactoryFactory;

public abstract class LLVMObjectAccessFactory {
    public static LLVMObjectAccess.LLVMObjectReadNode createRead() {
        return LLVMObjectAccessFactoryFactory.CachedReadNodeGen.create();
    }

    public static LLVMObjectAccess.LLVMObjectWriteNode createWrite() {
        return LLVMObjectAccessFactoryFactory.CachedWriteNodeGen.create();
    }

    static abstract class GetWriteIdentifierNode
    extends LLVMNode {
        GetWriteIdentifierNode() {
        }

        abstract long execute(long var1, Object var3);

        @Specialization
        long doByte(long offset, byte value) {
            return offset;
        }

        @Specialization
        long doShort(long offset, short value) {
            return offset / 2L;
        }

        @Specialization
        long doChar(long offset, char value) {
            return offset / 2L;
        }

        @Specialization
        long doInt(long offset, int value) {
            return offset / 4L;
        }

        @Specialization
        long doFloat(long offset, float value) {
            return offset / 4L;
        }

        @Fallback
        long doDouble(long offset, Object value) {
            return offset / 8L;
        }
    }

    static abstract class FallbackWriteNode
    extends LLVMNode
    implements LLVMObjectAccess.LLVMObjectWriteNode {
        @Node.Child
        private InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        private GetWriteIdentifierNode getWriteIdentifier = LLVMObjectAccessFactoryFactory.GetWriteIdentifierNodeGen.create();
        @Node.Child
        private UseLLVMObjectAccessNode useLLVMObjectAccess = LLVMObjectAccessFactoryFactory.UseLLVMObjectAccessNodeGen.create();

        FallbackWriteNode() {
        }

        @Override
        public boolean canAccess(Object obj) {
            return !this.useLLVMObjectAccess.executeWithTarget(obj) && this.interop.accepts(obj);
        }

        @Specialization(limit="3", guards={"type == cachedType"})
        void doCachedType(Object obj, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="type") ForeignToLLVM.ForeignToLLVMType cachedType, @Cached(parameters={"cachedType"}) LLVMDataEscapeNode dataEscape) {
            this.doWrite(obj, offset, value, dataEscape);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCachedType"})
        void doUncached(Object obj, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type) {
            this.doWrite(obj, offset, value, LLVMDataEscapeNode.getUncached(type));
        }

        private void doWrite(Object obj, long offset, Object value, LLVMDataEscapeNode dataEscape) {
            long identifier = this.getWriteIdentifier.execute(offset, value);
            Object escaped = dataEscape.executeWithTarget(value);
            try {
                this.interop.writeArrayElement(obj, identifier, escaped);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException(this, "Error writing to foreign array.");
            }
        }
    }

    static abstract class CachedWriteNode
    extends LLVMNode
    implements LLVMObjectAccess.LLVMObjectWriteNode {
        static final int TYPE_LIMIT = 8;

        CachedWriteNode() {
        }

        @Override
        public boolean canAccess(Object obj) {
            return obj instanceof TruffleObject;
        }

        @Specialization(limit="TYPE_LIMIT", guards={"impl.canAccess(obj)"})
        protected void doWrite(Object obj, long offset, Object value, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="createWriteNode(obj)") LLVMObjectAccess.LLVMObjectWriteNode impl) {
            impl.executeWrite(obj, offset, value, type);
        }

        LLVMObjectAccess.LLVMObjectWriteNode createWriteNode(Object obj) {
            DynamicObject dynamicObject;
            ObjectType objectType;
            if (obj instanceof LLVMObjectAccess) {
                return ((LLVMObjectAccess)obj).createWriteNode();
            }
            if (obj instanceof DynamicObject && (objectType = (dynamicObject = (DynamicObject)obj).getShape().getObjectType()) instanceof LLVMObjectAccess) {
                return ((LLVMObjectAccess)objectType).createWriteNode();
            }
            return LLVMObjectAccessFactoryFactory.FallbackWriteNodeGen.create();
        }
    }

    static abstract class UseLLVMObjectAccessNode
    extends LLVMNode {
        UseLLVMObjectAccessNode() {
        }

        public abstract boolean executeWithTarget(Object var1);

        @Specialization(guards={"obj.getClass() == cachedClass", "!isDynamicObject(cachedClass)"})
        protected boolean doNonDynamicObjectCached(Object obj, @Cached(value="obj.getClass()") Class<?> cachedClass) {
            return LLVMObjectAccess.class.isAssignableFrom(cachedClass);
        }

        @Specialization(guards={"cachedObjectTypeClass == obj.getShape().getObjectType().getClass()"})
        protected boolean doDynamicObjectCached(DynamicObject obj, @Cached(value="obj.getShape().getObjectType().getClass()") Class<?> cachedObjectTypeClass) {
            return LLVMObjectAccess.class.isAssignableFrom(cachedObjectTypeClass);
        }

        @Specialization(replaces={"doNonDynamicObjectCached", "doDynamicObjectCached"})
        protected boolean uncached(Object obj) {
            return obj instanceof LLVMObjectAccess || obj instanceof DynamicObject && ((DynamicObject)obj).getShape().getObjectType() instanceof LLVMObjectAccess;
        }

        protected boolean isDynamicObject(Class<?> clazz) {
            return DynamicObject.class.isAssignableFrom(clazz);
        }
    }

    static class FallbackReadNode
    extends LLVMNode
    implements LLVMObjectAccess.LLVMObjectReadNode {
        @Node.Child
        private InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        @Node.Child
        private ToLLVM toLLVM = ToLLVMNodeGen.create();
        @Node.Child
        private UseLLVMObjectAccessNode useLLVMObjectAccess = LLVMObjectAccessFactoryFactory.UseLLVMObjectAccessNodeGen.create();

        FallbackReadNode() {
        }

        @Override
        public boolean canAccess(Object obj) {
            return !this.useLLVMObjectAccess.executeWithTarget(obj) && this.interop.accepts(obj);
        }

        @Override
        public Object executeRead(Object obj, long offset, ForeignToLLVM.ForeignToLLVMType type) {
            try {
                Object foreign = this.interop.readArrayElement(obj, offset / (long)type.getSizeInBytes());
                return this.toLLVM.executeWithType(foreign, null, type);
            }
            catch (InteropException e) {
                CompilerDirectives.transferToInterpreter();
                throw new LLVMPolyglotException(this, "Error reading from foreign array.");
            }
        }
    }

    static abstract class CachedReadNode
    extends LLVMNode
    implements LLVMObjectAccess.LLVMObjectReadNode {
        static final int TYPE_LIMIT = 8;

        CachedReadNode() {
        }

        @Override
        public boolean canAccess(Object obj) {
            return obj instanceof LLVMObjectAccess || obj instanceof TruffleObject;
        }

        @Specialization(limit="TYPE_LIMIT", guards={"impl.canAccess(obj)"})
        protected Object doRead(Object obj, long offset, ForeignToLLVM.ForeignToLLVMType type, @Cached(value="createReadNode(obj)") LLVMObjectAccess.LLVMObjectReadNode impl) {
            return impl.executeRead(obj, offset, type);
        }

        protected LLVMObjectAccess.LLVMObjectReadNode createReadNode(Object obj) {
            DynamicObject dynamicObject;
            ObjectType objectType;
            if (obj instanceof LLVMObjectAccess) {
                return ((LLVMObjectAccess)obj).createReadNode();
            }
            if (obj instanceof DynamicObject && (objectType = (dynamicObject = (DynamicObject)obj).getShape().getObjectType()) instanceof LLVMObjectAccess) {
                return ((LLVMObjectAccess)objectType).createReadNode();
            }
            return new FallbackReadNode();
        }
    }
}

