/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMWriteNode;

public final class LLVMWritePhisNode
extends LLVMStatementNode {
    @Node.Children
    private final LLVMExpressionNode[] from;
    @Node.Children
    private final LLVMWriteNode[] writes;

    public LLVMWritePhisNode(LLVMExpressionNode[] from, LLVMWriteNode[] writes) {
        assert (from.length > 0 && writes.length > 0);
        this.from = from;
        this.writes = writes;
        assert (from.length == writes.length);
    }

    @Override
    public void execute(VirtualFrame frame) {
        if (this.from.length == 1) {
            this.writes[0].executeWithTarget(frame, this.from[0].executeGeneric(frame));
        } else {
            Object[] values = this.readValues(frame);
            this.writeValues(frame, values);
        }
    }

    @ExplodeLoop
    private Object[] readValues(VirtualFrame frame) {
        Object[] result = new Object[this.from.length];
        for (int i = 0; i < this.from.length; ++i) {
            result[i] = this.from[i].executeGeneric(frame);
        }
        return result;
    }

    @ExplodeLoop
    private void writeValues(VirtualFrame frame, Object[] values) {
        for (int i = 0; i < this.writes.length; ++i) {
            this.writes[i].executeWithTarget(frame, values[i]);
        }
    }
}

