/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNodeWrapper;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMCompareNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMCompareNodeFactory;

@GenerateWrapper
public abstract class LLVMSwitchNode
extends LLVMControlFlowNode {
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMSwitchNodeWrapper(this, probe);
    }

    public abstract Object executeCondition(VirtualFrame var1);

    public abstract int[] getSuccessors();

    public abstract boolean executeIsCase(VirtualFrame var1, int var2, Object var3);

    public static class LLVMSwitchNodeImpl
    extends LLVMSwitchNode {
        @Node.Children
        private final LLVMStatementNode[] phiNodes;
        @Node.Child
        protected LLVMExpressionNode cond;
        @Node.Children
        protected final LLVMExpressionNode[] cases;
        @Node.Children
        protected final LLVMCompareNode.LLVMEqNode[] caseEquals;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] successors;
        private final ValueProfile conditionValueClass = ValueProfile.createClassProfile();

        public LLVMSwitchNodeImpl(int[] successors, LLVMStatementNode[] phiNodes, LLVMExpressionNode cond, LLVMExpressionNode[] cases) {
            assert (successors.length == cases.length + 1) : "the last entry of the successors array must be the default case";
            this.successors = successors;
            this.phiNodes = phiNodes;
            this.cond = cond;
            this.cases = cases;
            this.caseEquals = new LLVMCompareNode.LLVMEqNode[cases.length];
            for (int i = 0; i < this.caseEquals.length; ++i) {
                this.caseEquals[i] = LLVMCompareNodeFactory.LLVMEqNodeGen.create(null, null);
            }
        }

        @Override
        public Object executeCondition(VirtualFrame frame) {
            return this.conditionValueClass.profile(this.cond.executeGeneric(frame));
        }

        @Override
        public int[] getSuccessors() {
            return this.successors;
        }

        @Override
        public int getSuccessorCount() {
            return this.successors.length;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            return this.phiNodes[successorIndex];
        }

        @Override
        public boolean executeIsCase(VirtualFrame frame, int i, Object value) {
            return this.caseEquals[i].executeWithTarget(this.cases[i].executeGeneric(frame), value);
        }
    }
}

