/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNodeWrapper;

@GenerateWrapper
public abstract class LLVMIndirectBranchNode
extends LLVMControlFlowNode {
    public static LLVMIndirectBranchNode create(LLVMBranchAddressNode branchAddress, int[] indices, LLVMStatementNode[] phiWriteNodes) {
        return new LLVMIndirectBranchNodeImpl(branchAddress, indices, phiWriteNodes);
    }

    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new LLVMIndirectBranchNodeWrapper(this, probe);
    }

    public abstract int executeCondition(VirtualFrame var1);

    public abstract int[] getSuccessors();

    public static final class LLVMBasicBranchAddressNode
    extends LLVMBranchAddressNode {
        @Node.Child
        private LLVMExpressionNode address;

        public LLVMBasicBranchAddressNode(LLVMExpressionNode address) {
            this.address = address;
        }

        @Override
        public int branchAddress(VirtualFrame frame) {
            try {
                return (int)this.address.executeLLVMNativePointer(frame).asNative();
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("should not reach here", e);
            }
        }
    }

    public static abstract class LLVMBranchAddressNode
    extends LLVMNode {
        public abstract int branchAddress(VirtualFrame var1);
    }

    private static final class LLVMIndirectBranchNodeImpl
    extends LLVMIndirectBranchNode {
        @Node.Child
        private LLVMBranchAddressNode branchAddress;
        @Node.Children
        private final LLVMStatementNode[] phiWriteNodes;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] successors;

        private LLVMIndirectBranchNodeImpl(LLVMBranchAddressNode branchAddress, int[] indices, LLVMStatementNode[] phiWriteNodes) {
            assert (indices.length > 1);
            this.successors = indices;
            this.branchAddress = branchAddress;
            this.phiWriteNodes = phiWriteNodes;
        }

        @Override
        public int getSuccessorCount() {
            return this.successors.length;
        }

        @Override
        public LLVMStatementNode getPhiNode(int successorIndex) {
            return this.phiWriteNodes[successorIndex];
        }

        @Override
        public int executeCondition(VirtualFrame frame) {
            return this.branchAddress.branchAddress(frame);
        }

        @Override
        public int[] getSuccessors() {
            return this.successors;
        }
    }
}

