/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMUserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMFrameNullerUtil;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMBrUnconditionalNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMIndirectBranchNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMSwitchNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMInvokeNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMResumeNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnreachableNode;

public final class LLVMDispatchBasicBlockNode
extends LLVMExpressionNode {
    private final FrameSlot exceptionValueSlot;
    @Node.Children
    private final LLVMBasicBlockNode[] bodyNodes;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final FrameSlot[][] beforeBlockNuller;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final FrameSlot[][] afterBlockNuller;

    public LLVMDispatchBasicBlockNode(FrameSlot exceptionValueSlot, LLVMBasicBlockNode[] bodyNodes, FrameSlot[][] beforeBlockNuller, FrameSlot[][] afterBlockNuller) {
        this.exceptionValueSlot = exceptionValueSlot;
        this.bodyNodes = bodyNodes;
        this.beforeBlockNuller = beforeBlockNuller;
        this.afterBlockNuller = afterBlockNuller;
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    public Object executeGeneric(VirtualFrame frame) {
        Object returnValue = null;
        CompilerAsserts.compilationConstant((Object)this.bodyNodes.length);
        int basicBlockIndex = 0;
        int backEdgeCounter = 0;
        block2: while (basicBlockIndex != -1) {
            int i;
            CompilerAsserts.partialEvaluationConstant((int)basicBlockIndex);
            LLVMBasicBlockNode bb = this.bodyNodes[basicBlockIndex];
            bb.initialize();
            bb = this.bodyNodes[basicBlockIndex];
            bb.execute(frame);
            LLVMControlFlowNode controlFlowNode = bb.getTerminatingInstruction();
            if (controlFlowNode instanceof LLVMConditionalBranchNode) {
                LLVMConditionalBranchNode conditionalBranchNode = (LLVMConditionalBranchNode)controlFlowNode;
                boolean condition = conditionalBranchNode.executeCondition(frame);
                if (CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(0), (boolean)condition)) {
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(0);
                        if (conditionalBranchNode.getTrueSuccessor() <= basicBlockIndex) {
                            ++backEdgeCounter;
                        }
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                    LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 0);
                    basicBlockIndex = conditionalBranchNode.getTrueSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                    continue;
                }
                if (CompilerDirectives.inInterpreter()) {
                    bb.increaseBranchProbability(1);
                    if (conditionalBranchNode.getFalseSuccessor() <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                }
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                LLVMDispatchBasicBlockNode.executePhis(frame, conditionalBranchNode, 1);
                basicBlockIndex = conditionalBranchNode.getFalseSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                continue;
            }
            if (controlFlowNode instanceof LLVMSwitchNode) {
                LLVMSwitchNode switchNode = (LLVMSwitchNode)controlFlowNode;
                Object condition = switchNode.executeCondition(frame);
                int[] successors = switchNode.getSuccessors();
                for (i = 0; i < successors.length - 1; ++i) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (boolean)switchNode.executeIsCase(frame, i, condition))) continue;
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(i);
                        if (successors[i] <= basicBlockIndex) {
                            ++backEdgeCounter;
                        }
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                    LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                    continue block2;
                }
                i = successors.length - 1;
                if (CompilerDirectives.inInterpreter()) {
                    bb.increaseBranchProbability(i);
                    if (successors[i] <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                }
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                LLVMDispatchBasicBlockNode.executePhis(frame, switchNode, i);
                basicBlockIndex = successors[i];
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                continue;
            }
            if (controlFlowNode instanceof LLVMIndirectBranchNode) {
                LLVMIndirectBranchNode indirectBranchNode = (LLVMIndirectBranchNode)controlFlowNode;
                int[] successors = indirectBranchNode.getSuccessors();
                int successorBasicBlockIndex = indirectBranchNode.executeCondition(frame);
                for (i = 0; i < successors.length - 1; ++i) {
                    if (!CompilerDirectives.injectBranchProbability((double)bb.getBranchProbability(i), (successors[i] == successorBasicBlockIndex ? (byte)1 : 0) != 0)) continue;
                    if (CompilerDirectives.inInterpreter()) {
                        bb.increaseBranchProbability(i);
                        if (successors[i] <= basicBlockIndex) {
                            ++backEdgeCounter;
                        }
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                    LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                    basicBlockIndex = successors[i];
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                    continue block2;
                }
                i = successors.length - 1;
                assert (successorBasicBlockIndex == successors[i]);
                if (CompilerDirectives.inInterpreter()) {
                    bb.increaseBranchProbability(i);
                    if (successors[i] <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                }
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                LLVMDispatchBasicBlockNode.executePhis(frame, indirectBranchNode, i);
                basicBlockIndex = successors[i];
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                continue;
            }
            if (controlFlowNode instanceof LLVMBrUnconditionalNode) {
                LLVMBrUnconditionalNode unconditionalNode = (LLVMBrUnconditionalNode)controlFlowNode;
                if (CompilerDirectives.inInterpreter() && unconditionalNode.getSuccessor() <= basicBlockIndex) {
                    ++backEdgeCounter;
                }
                unconditionalNode.execute(frame);
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                LLVMDispatchBasicBlockNode.executePhis(frame, unconditionalNode, 0);
                basicBlockIndex = unconditionalNode.getSuccessor();
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                continue;
            }
            if (controlFlowNode instanceof LLVMInvokeNode) {
                LLVMInvokeNode invokeNode = (LLVMInvokeNode)controlFlowNode;
                try {
                    invokeNode.execute(frame);
                    if (CompilerDirectives.inInterpreter() && invokeNode.getNormalSuccessor() <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                    LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 0);
                    basicBlockIndex = invokeNode.getNormalSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                }
                catch (LLVMUserException e) {
                    frame.setObject(this.exceptionValueSlot, (Object)e);
                    if (CompilerDirectives.inInterpreter() && invokeNode.getUnwindSuccessor() <= basicBlockIndex) {
                        ++backEdgeCounter;
                    }
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                    LLVMDispatchBasicBlockNode.executePhis(frame, invokeNode, 1);
                    basicBlockIndex = invokeNode.getUnwindSuccessor();
                    LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.beforeBlockNuller);
                }
                continue;
            }
            if (controlFlowNode instanceof LLVMRetNode) {
                LLVMRetNode retNode = (LLVMRetNode)controlFlowNode;
                returnValue = retNode.execute(frame);
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(retNode));
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                basicBlockIndex = retNode.getSuccessor();
                continue;
            }
            if (controlFlowNode instanceof LLVMResumeNode) {
                LLVMResumeNode resumeNode = (LLVMResumeNode)controlFlowNode;
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(resumeNode));
                LLVMDispatchBasicBlockNode.nullDeadSlots(frame, basicBlockIndex, this.afterBlockNuller);
                resumeNode.execute(frame);
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("must not reach here");
            }
            if (controlFlowNode instanceof LLVMUnreachableNode) {
                LLVMUnreachableNode unreachableNode = (LLVMUnreachableNode)controlFlowNode;
                assert (LLVMDispatchBasicBlockNode.noPhisNecessary(unreachableNode));
                unreachableNode.execute(frame);
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("must not reach here");
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unexpected controlFlowNode type: " + (Object)((Object)controlFlowNode));
        }
        assert (backEdgeCounter >= 0);
        LoopNode.reportLoopCount((Node)this, (int)backEdgeCounter);
        return returnValue;
    }

    @ExplodeLoop
    private static void executePhis(VirtualFrame frame, LLVMControlFlowNode controlFlowNode, int successorIndex) {
        LLVMStatementNode phi = controlFlowNode.getPhiNode(successorIndex);
        if (phi != null) {
            phi.execute(frame);
        }
    }

    @ExplodeLoop
    private static void nullDeadSlots(VirtualFrame frame, int bci, FrameSlot[][] blockNullers) {
        FrameSlot[] frameSlotsToNull = blockNullers[bci];
        if (frameSlotsToNull != null) {
            assert (frameSlotsToNull.length > 0);
            for (int i = 0; i < frameSlotsToNull.length; ++i) {
                LLVMFrameNullerUtil.nullFrameSlot(frame, frameSlotsToNull[i], false);
            }
        }
    }

    private static boolean noPhisNecessary(LLVMControlFlowNode controlFlowNode) {
        return controlFlowNode.getSuccessorCount() == 0 || controlFlowNode.getSuccessorCount() == 1 && controlFlowNode.getPhiNode(0) == null;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return false;
        }
        if (tag == StandardTags.RootBodyTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }
}

