/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVectorNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

public abstract class LLVMToVectorZeroExtNode
extends LLVMToVectorNode {

    public static abstract class LLVMUnsignedCastToI64VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) ? 1L : 0L;
            }
            return LLVMI64Vector.create(vector);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) & 0xFF;
            }
            return LLVMI64Vector.create(vector);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) & 0xFFFF;
            }
            return LLVMI64Vector.create(vector);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI64Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            long[] vector = new long[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (long)from.getValue(i) & 0xFFFFFFFFL;
            }
            return LLVMI64Vector.create(vector);
        }

        @Specialization
        protected LLVMI64Vector doI64Vector(LLVMI64Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }

    public static abstract class LLVMUnsignedCastToI32VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI32Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) ? 1 : 0;
            }
            return LLVMI32Vector.create(vector);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI32Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) & 0xFF;
            }
            return LLVMI32Vector.create(vector);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI32Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            int[] vector = new int[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = from.getValue(i) & 0xFFFF;
            }
            return LLVMI32Vector.create(vector);
        }

        @Specialization
        protected LLVMI32Vector doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }

    public static abstract class LLVMUnsignedCastToI16VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI16Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)(from.getValue(i) ? 1 : 0);
            }
            return LLVMI16Vector.create(vector);
        }

        @ExplodeLoop
        @Specialization
        protected LLVMI16Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            short[] vector = new short[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (short)(from.getValue(i) & 0xFF);
            }
            return LLVMI16Vector.create(vector);
        }

        @Specialization
        protected LLVMI16Vector doI16Vector(LLVMI16Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }

    public static abstract class LLVMUnsignedCastToI8VectorNode
    extends LLVMToVectorNode {
        @ExplodeLoop
        @Specialization
        protected LLVMI8Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            byte[] vector = new byte[this.getVectorLength()];
            for (int i = 0; i < this.getVectorLength(); ++i) {
                vector[i] = (byte)(from.getValue(i) ? 1 : 0);
            }
            return LLVMI8Vector.create(vector);
        }

        @Specialization
        protected LLVMI8Vector doI8Vector(LLVMI8Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }

    public static abstract class LLVMUnsignedCastToI1VectorNode
    extends LLVMToVectorNode {
        @Specialization
        protected LLVMI1Vector doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == this.getVectorLength());
            return from;
        }
    }
}

