/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToVarINode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMToVarINode.class)
public final class LLVMToVarINodeGen
extends LLVMToVarINode {
    private final int bits;
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private LLVMToNativeNode toNative_;
    @Node.Child
    private LLVMToVarINode recursive_;

    private LLVMToVarINodeGen(LLVMExpressionNode fromNode, int bits) {
        this.bits = bits;
        this.fromNode_ = fromNode;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    protected LLVMIVarBit executeWith(long fromNodeValue) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AssertionError((Object)"Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (state != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            return this.doPointer(fromNodeValue__, this.toNative_, this.recursive_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                this.toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                this.recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.toNative_, this.recursive_);
                return lLVMIVarBit;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static LLVMToVarINode create(LLVMExpressionNode fromNode, int bits) {
        return new LLVMToVarINodeGen(fromNode, bits);
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMBitcastToIVarNode.class)
    public static final class LLVMBitcastToIVarNodeGen
    extends LLVMToVarINode.LLVMBitcastToIVarNode {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToVarINode pointer_recursive_;

        private LLVMBitcastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x10) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1FD) == 0 && (state & 0x1FF) != 0) {
                return this.executeGeneric_byte0(frameValue, state);
            }
            if ((state & 0x1FB) == 0 && (state & 0x1FF) != 0) {
                return this.executeGeneric_short1(frameValue, state);
            }
            if ((state & 0x1F7) == 0 && (state & 0x1FF) != 0) {
                return this.executeGeneric_int2(frameValue, state);
            }
            if ((state & 0x1EF) == 0 && (state & 0x1FF) != 0) {
                return this.executeGeneric_long3(frameValue, state);
            }
            if ((state & 0x1BF) == 0 && (state & 0x1FF) != 0) {
                return this.executeGeneric_float4(frameValue, state);
            }
            if ((state & 0x17F) == 0 && (state & 0x1FF) != 0) {
                return this.executeGeneric_double5(frameValue, state);
            }
            return this.executeGeneric_generic6(frameValue, state);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float4(VirtualFrame frameValue, int state) {
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x40) != 0);
            return this.doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double5(VirtualFrame frameValue, int state) {
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x80) != 0);
            return this.doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic6(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state & 0xE00) >>> 9, fromNodeValue_)) {
                LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state & 0xE00) >>> 9, fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && fromNodeValue_ instanceof Float) {
                float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                return this.doFloat(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof Double) {
                double fromNodeValue__ = (Double)fromNodeValue_;
                return this.doDouble(fromNodeValue__);
            }
            if ((state & 0x100) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI8(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI16(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI32(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI64(fromNodeValue_);
                    return lLVMIVarBit;
                }
                int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
                if (lLVMIVarBitCast0 != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state |= lLVMIVarBitCast0 << 9;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Float) {
                    float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doFloat(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doDouble(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.do80BitFloat(fromNodeValue_);
                    return lLVMIVarBit;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 0x1FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 0x1FF & (state & 0x1FF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVarINode.LLVMBitcastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMBitcastToIVarNodeGen(fromNode, bits);
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMUnsignedCastToIVarNode.class)
    public static final class LLVMUnsignedCastToIVarNodeGen
    extends LLVMToVarINode.LLVMUnsignedCastToIVarNode {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToVarINode pointer_recursive_;

        private LLVMUnsignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x10) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x7D) == 0 && state != 0) {
                return this.executeGeneric_byte0(frameValue, state);
            }
            if ((state & 0x7B) == 0 && state != 0) {
                return this.executeGeneric_short1(frameValue, state);
            }
            if ((state & 0x77) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state);
            }
            if ((state & 0x6F) == 0 && state != 0) {
                return this.executeGeneric_long3(frameValue, state);
            }
            return this.executeGeneric_generic4(frameValue, state);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                LLVMIVarBitSmall fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI8(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI16(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI32(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI64(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                    LLVMIVarBitSmall fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVarINode.LLVMUnsignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMUnsignedCastToIVarNodeGen(fromNode, bits);
        }
    }

    @GeneratedBy(value=LLVMToVarINode.LLVMSignedCastToIVarNode.class)
    public static final class LLVMSignedCastToIVarNodeGen
    extends LLVMToVarINode.LLVMSignedCastToIVarNode {
        private final int bits;
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private LLVMToNativeNode pointer_toNative_;
        @Node.Child
        private LLVMToVarINode pointer_recursive_;

        private LLVMSignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state = this.state_;
            if ((state & 0x10) != 0) {
                return this.doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0xFD) == 0 && state != 0) {
                return this.executeGeneric_byte0(frameValue, state);
            }
            if ((state & 0xFB) == 0 && state != 0) {
                return this.executeGeneric_short1(frameValue, state);
            }
            if ((state & 0xF7) == 0 && state != 0) {
                return this.executeGeneric_int2(frameValue, state);
            }
            if ((state & 0xEF) == 0 && state != 0) {
                return this.executeGeneric_long3(frameValue, state);
            }
            return this.executeGeneric_generic4(frameValue, state);
        }

        private Object executeGeneric_byte0(VirtualFrame frameValue, int state) {
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 2) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short1(VirtualFrame frameValue, int state) {
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 4) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int2(VirtualFrame frameValue, int state) {
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 8) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long3(VirtualFrame frameValue, int state) {
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic4(VirtualFrame frameValue, int state) {
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if ((state & 1) != 0 && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return this.doPointer(fromNodeValue__, this.pointer_toNative_, this.pointer_recursive_);
            }
            if ((state & 2) != 0 && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (Byte)fromNodeValue_;
                return this.doI8(fromNodeValue__);
            }
            if ((state & 4) != 0 && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (Short)fromNodeValue_;
                return this.doI16(fromNodeValue__);
            }
            if ((state & 8) != 0 && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (Integer)fromNodeValue_;
                return this.doI32(fromNodeValue__);
            }
            if ((state & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (Long)fromNodeValue_;
                return this.doI64(fromNodeValue__);
            }
            if ((state & 0x20) != 0 && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state & 0x40) != 0 && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                LLVMIVarBitSmall fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                return this.doIVarBit(fromNodeValue__);
            }
            if ((state & 0x80) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                return this.do80BitFloat(fromNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (LLVMTypes.isPointer(fromNodeValue)) {
                    LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                    this.pointer_toNative_ = (LLVMToNativeNode)super.insert((Node)LLVMToNativeNode.createToNativeWithTarget());
                    this.pointer_recursive_ = (LLVMToVarINode)super.insert((Node)this.createRecursive());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doPointer(fromNodeValue_, this.pointer_toNative_, this.pointer_recursive_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI8(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI16(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI32(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doI64(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                    LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                    LLVMIVarBitSmall fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.doIVarBit(fromNodeValue_);
                    return lLVMIVarBit;
                }
                if (fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    LLVMIVarBit lLVMIVarBit = this.do80BitFloat(fromNodeValue_);
                    return lLVMIVarBit;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMToVarINode.LLVMSignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMSignedCastToIVarNodeGen(fromNode, bits);
        }
    }
}

