/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToI1Node
extends LLVMExpressionNode {
    @Specialization(guards={"isForeign(from)"})
    protected boolean doManagedPointer(LLVMManagedPointer from, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM) {
        return (Boolean)toLLVM.executeWithTarget(from.getObject());
    }

    @Specialization
    protected boolean doPointer(LLVMNativePointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative) {
        return (toNative.executeWithTarget(from).asNative() & 1L) != 0L;
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.I1);
    }

    protected boolean isForeign(LLVMManagedPointer pointer) {
        return pointer.getOffset() == 0L && LLVMToI1Node.notLLVM(pointer);
    }

    public static abstract class LLVMBitcastToI1Node
    extends LLVMToI1Node {
        @Specialization
        protected boolean doI1(boolean from) {
            return from;
        }

        @Specialization
        protected boolean doI1Vector(LLVMI1Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }
    }

    public static abstract class LLVMSignedCastToI1Node
    extends LLVMToI1Node {
        @Specialization
        protected boolean doBoolean(boolean from) {
            return from;
        }

        @Specialization
        protected boolean doByte(byte from) {
            return (from & 1) != 0;
        }

        @Specialization
        protected boolean doShort(short from) {
            return (from & 1) != 0;
        }

        @Specialization
        protected boolean doInt(int from) {
            return (from & 1) != 0;
        }

        @Specialization
        protected boolean doLong(long from) {
            return (from & 1L) != 0L;
        }

        @Specialization
        protected boolean doLLVMIVarBit(LLVMIVarBit from) {
            return this.doByte(from.getByteValue());
        }

        @Specialization
        protected boolean doFloat(float from) {
            return ((int)from & 1) != 0;
        }

        @Specialization
        protected boolean doDouble(double from) {
            return ((long)from & 1L) != 0L;
        }

        @Specialization
        protected boolean doLLVM80BitFloat(LLVM80BitFloat from) {
            return (from.getLongValue() & 1L) != 0L;
        }
    }
}

