/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChild(value="fromNode", type=LLVMExpressionNode.class)
public abstract class LLVMToFloatNode
extends LLVMExpressionNode {
    protected abstract float executeWith(long var1);

    protected LLVMToFloatNode createRecursive() {
        throw new IllegalStateException("abstract node LLVMToFloatNode used");
    }

    @Specialization(guards={"isForeign(from)"})
    protected float doManagedPointer(LLVMManagedPointer from, @Cached(value="createForeignToLLVM()") ForeignToLLVM toLLVM, @Cached(value="createRecursive()") LLVMToFloatNode recursive) {
        long ptr = (Long)toLLVM.executeWithTarget(from.getObject());
        return recursive.executeWith(ptr);
    }

    @Specialization
    protected float doPointer(LLVMPointer from, @Cached(value="createToNativeWithTarget()") LLVMToNativeNode toNative, @Cached(value="createRecursive()") LLVMToFloatNode recursive) {
        long ptr = toNative.executeWithTarget(from).asNative();
        return recursive.executeWith(ptr);
    }

    protected ForeignToLLVM createForeignToLLVM() {
        return CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.FLOAT);
    }

    protected boolean isForeign(LLVMManagedPointer pointer) {
        return pointer.getOffset() == 0L && LLVMToFloatNode.notLLVM(pointer.getObject());
    }

    public static abstract class LLVMBitcastToFloatNode
    extends LLVMToFloatNode {
        @Override
        protected LLVMToFloatNode createRecursive() {
            return LLVMToFloatNodeGen.LLVMBitcastToFloatNodeGen.create(null);
        }

        @Specialization
        protected float doFloat(int from) {
            return Float.intBitsToFloat(from);
        }

        @Specialization
        protected float doFloat(float from) {
            return from;
        }

        @Specialization
        protected float doI1Vector(LLVMI1Vector from) {
            int res = (int)LLVMToI64Node.LLVMBitcastToI64Node.castI1Vector(from, 32);
            return Float.intBitsToFloat(res);
        }

        @Specialization
        protected float doI8Vector(LLVMI8Vector from) {
            int res = (int)LLVMToI64Node.LLVMBitcastToI64Node.castI8Vector(from, 4);
            return Float.intBitsToFloat(res);
        }

        @Specialization
        protected float doI16Vector(LLVMI16Vector from) {
            int res = (int)LLVMToI64Node.LLVMBitcastToI64Node.castI16Vector(from, 2);
            return Float.intBitsToFloat(res);
        }

        @Specialization
        protected float doI32Vector(LLVMI32Vector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return Float.intBitsToFloat(from.getValue(0));
        }

        @Specialization
        protected float doFloatVector(LLVMFloatVector from) {
            assert (from.getLength() == 1) : "invalid vector size";
            return from.getValue(0);
        }
    }

    public static abstract class LLVMUnsignedCastToFloatNode
    extends LLVMToFloatNode {
        private static final float LEADING_BIT = 9.223372E18f;

        @Override
        protected LLVMToFloatNode createRecursive() {
            return LLVMToFloatNodeGen.LLVMUnsignedCastToFloatNodeGen.create(null);
        }

        @Specialization
        protected float doFloat(boolean from) {
            return from ? 1.0f : 0.0f;
        }

        @Specialization
        protected float doFloat(byte from) {
            return from & 0xFF;
        }

        @Specialization
        protected float doFloat(short from) {
            return from & 0xFFFF;
        }

        @Specialization
        protected float doFloat(int from) {
            return (long)from & 0xFFFFFFFFL;
        }

        @Specialization
        protected float doFloat(long from) {
            float val = from & Long.MAX_VALUE;
            if (from < 0L) {
                val += 9.223372E18f;
            }
            return val;
        }

        @Specialization
        protected float doFloat(float from) {
            return from;
        }
    }

    public static abstract class LLVMSignedCastToFloatNode
    extends LLVMToFloatNode {
        @Override
        protected LLVMToFloatNode createRecursive() {
            return LLVMToFloatNodeGen.LLVMSignedCastToFloatNodeGen.create(null);
        }

        @Specialization
        protected float doFloat(boolean from) {
            return from ? 1.0f : 0.0f;
        }

        @Specialization
        protected float doFloat(byte from) {
            return from;
        }

        @Specialization
        protected float doFloat(short from) {
            return from;
        }

        @Specialization
        protected float doFloat(int from) {
            return from;
        }

        @Specialization
        protected float doFloat(long from) {
            return from;
        }

        @Specialization
        protected float doFloat(float from) {
            return from;
        }

        @Specialization
        protected float doFloat(double from) {
            return (float)from;
        }

        @Specialization
        protected float doFloat(LLVM80BitFloat from) {
            return from.getFloatValue();
        }
    }
}

