/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMSyscallEntry;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMInfo;

public final class LLVMUnsupportedSyscallNode
extends LLVMSyscallOperationNode {
    private final LLVMSyscallEntry syscall;
    private final long nr;

    public static LLVMUnsupportedSyscallNode create(long nr) {
        return new LLVMUnsupportedSyscallNode(nr, null);
    }

    public static LLVMUnsupportedSyscallNode create(LLVMSyscallEntry syscall) {
        return new LLVMUnsupportedSyscallNode(syscall.value(), syscall);
    }

    private LLVMUnsupportedSyscallNode(long nr, LLVMSyscallEntry syscall) {
        this.nr = nr;
        this.syscall = syscall;
    }

    @Override
    public String getName() {
        if (this.syscall != null) {
            return this.syscall.toString();
        }
        return "unsupported(" + this.nr + ")";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long execute(Object rdi, Object rsi, Object rdx, Object r10, Object r8, Object r9) {
        String details = this.syscall != null ? this.syscall.toString() : "0x" + Long.toHexString(this.nr) + " (" + this.nr + ")";
        throw new LLVMUnsupportedException((Node)this, LLVMUnsupportedException.UnsupportedReason.UNSUPPORTED_SYSCALL, String.format("%s (%s %s)", details, LLVMInfo.SYSNAME, LLVMInfo.MACHINE));
    }
}

