/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerAsserts;

public class LLVMProcessStat {
    private final String stat;
    private final long pid;
    private final String comm;
    private final char state;
    private final long ppid;
    private final long pgrp;
    private final long session;
    private final long ttyNr;
    private final long tpgid;

    public LLVMProcessStat(String stat) {
        CompilerAsserts.neverPartOfCompilation();
        this.stat = stat;
        String[] fields = stat.split(" ");
        this.pid = Long.parseLong(fields[0]);
        this.comm = fields[1];
        this.state = fields[2].charAt(0);
        this.ppid = Long.parseLong(fields[3]);
        this.pgrp = Long.parseLong(fields[4]);
        this.session = Long.parseLong(fields[5]);
        this.ttyNr = Long.parseLong(fields[6]);
        this.tpgid = Long.parseLong(fields[7]);
    }

    public long getPid() {
        return this.pid;
    }

    public String getComm() {
        return this.comm;
    }

    public char getState() {
        return this.state;
    }

    public long getPpid() {
        return this.ppid;
    }

    public long getPgrp() {
        return this.pgrp;
    }

    public long getSession() {
        return this.session;
    }

    public long getTTYNr() {
        return this.ttyNr;
    }

    public long getTpgid() {
        return this.tpgid;
    }

    public String toString() {
        return this.stat;
    }
}

