/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.io.PrintStream;

@NodeChildren(value={@NodeChild(value="rax"), @NodeChild(value="rdi"), @NodeChild(value="rsi"), @NodeChild(value="rdx"), @NodeChild(value="r10"), @NodeChild(value="r8"), @NodeChild(value="r9")})
public abstract class LLVMAMD64SyscallNode
extends LLVMExpressionNode {
    protected static final int NUM_SYSCALLS = 332;
    @CompilerDirectives.CompilationFinal
    private boolean traceEnabledFlag;
    @CompilerDirectives.CompilationFinal
    private PrintStream traceStream;

    protected LLVMSyscallOperationNode createNode(long rax) {
        return LLVMLanguage.getLanguage().getCapability(PlatformCapability.class).createSyscallNode(rax);
    }

    @Specialization(guards={"rax == cachedRax"}, limit="NUM_SYSCALLS")
    protected long cachedSyscall(long rax, Object rdi, Object rsi, Object rdx, Object r10, Object r8, Object r9, @Cached(value="rax") long cachedRax, @Cached(value="createNode(rax)") LLVMSyscallOperationNode node) {
        if (this.traceEnabled()) {
            this.trace("[sulong] syscall: %s (%s, %s, %s, %s, %s, %s)\n", LLVMAMD64SyscallNode.getNodeName(node), rdi, rsi, rdx, r10, r8, r9);
        }
        long result = node.execute(rdi, rsi, rdx, r10, r8, r9);
        if (this.traceEnabled()) {
            this.trace("         result: %d\n", result);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static String getNodeName(LLVMSyscallOperationNode node) {
        return node.getName();
    }

    @Specialization(replaces={"cachedSyscall"})
    protected long doI64(long rax, Object rdi, Object rsi, Object rdx, Object r10, Object r8, Object r9) {
        CompilerDirectives.transferToInterpreter();
        return this.createNode(rax).execute(rdi, rsi, rdx, r10, r8, r9);
    }

    private void cacheTrace() {
        if (this.traceStream == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.traceStream = SulongEngineOption.getStream((String)((LLVMContext)this.lookupContextReference(LLVMLanguage.class).get()).getEnv().getOptions().get(SulongEngineOption.DEBUG_SYSCALLS));
            this.traceEnabledFlag = SulongEngineOption.isTrue((String)((LLVMContext)this.lookupContextReference(LLVMLanguage.class).get()).getEnv().getOptions().get(SulongEngineOption.DEBUG_SYSCALLS));
        }
    }

    private boolean traceEnabled() {
        this.cacheTrace();
        return this.traceEnabledFlag;
    }

    private PrintStream traceStream() {
        this.cacheTrace();
        return this.traceStream;
    }

    @CompilerDirectives.TruffleBoundary
    private void trace(String format, Object ... args) {
        this.traceStream().printf(format, args);
    }
}

