/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;

public class LLVMAMD64UpdateFlagsNode
extends LLVMNode {
    public static boolean getParity(byte value) {
        return LLVMAMD64UpdateFlagsNode.getParity((int)value);
    }

    public static boolean getParity(short value) {
        return LLVMAMD64UpdateFlagsNode.getParity((int)value);
    }

    public static boolean getParity(int value) {
        return (Integer.bitCount(value & 0xFF) & 1) == 0;
    }

    public static boolean getParity(long value) {
        return (Long.bitCount(value & 0xFFL) & 1) == 0;
    }

    public static class LLVMAMD64UpdateCPAZSOFlagsNode
    extends LLVMAMD64UpdateFlagsNode {
        private final FrameSlot cf;
        private final FrameSlot pf;
        private final FrameSlot af;
        private final FrameSlot zf;
        private final FrameSlot sf;
        private final FrameSlot of;

        public LLVMAMD64UpdateCPAZSOFlagsNode(FrameSlot cf, FrameSlot pf, FrameSlot af, FrameSlot zf, FrameSlot sf, FrameSlot of) {
            this.cf = cf;
            this.pf = pf;
            this.af = af;
            this.zf = zf;
            this.sf = sf;
            this.of = of;
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, boolean adjust, byte value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.af, adjust);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPAZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, boolean adjust, short value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.af, adjust);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPAZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, boolean adjust, int value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.af, adjust);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPAZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, boolean adjust, long value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.af, adjust);
            frame.setBoolean(this.sf, value < 0L);
            frame.setBoolean(this.zf, value == 0L);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPAZSOFlagsNode.getParity(value));
        }
    }

    public static class LLVMAMD64UpdateCPZSOFlagsNode
    extends LLVMAMD64UpdateFlagsNode {
        private final FrameSlot cf;
        private final FrameSlot pf;
        private final FrameSlot zf;
        private final FrameSlot sf;
        private final FrameSlot of;

        public LLVMAMD64UpdateCPZSOFlagsNode(FrameSlot cf, FrameSlot pf, FrameSlot zf, FrameSlot sf, FrameSlot of) {
            this.cf = cf;
            this.pf = pf;
            this.zf = zf;
            this.sf = sf;
            this.of = of;
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, byte value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, short value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, int value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, boolean carry, long value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.cf, carry);
            frame.setBoolean(this.sf, value < 0L);
            frame.setBoolean(this.zf, value == 0L);
            frame.setBoolean(this.pf, LLVMAMD64UpdateCPZSOFlagsNode.getParity(value));
        }
    }

    public static class LLVMAMD64UpdatePZSOFlagsNode
    extends LLVMAMD64UpdateFlagsNode {
        private final FrameSlot pf;
        private final FrameSlot zf;
        private final FrameSlot sf;
        private final FrameSlot of;

        public LLVMAMD64UpdatePZSOFlagsNode(FrameSlot pf, FrameSlot zf, FrameSlot sf, FrameSlot of) {
            this.pf = pf;
            this.zf = zf;
            this.sf = sf;
            this.of = of;
        }

        public void execute(VirtualFrame frame, boolean overflow, byte value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, short value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, int value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSOFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, boolean overflow, long value) {
            frame.setBoolean(this.of, overflow);
            frame.setBoolean(this.sf, value < 0L);
            frame.setBoolean(this.zf, value == 0L);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSOFlagsNode.getParity(value));
        }
    }

    public static class LLVMAMD64UpdatePZSFlagsNode
    extends LLVMAMD64UpdateFlagsNode {
        private final FrameSlot pf;
        private final FrameSlot zf;
        private final FrameSlot sf;

        public LLVMAMD64UpdatePZSFlagsNode(FrameSlot pf, FrameSlot zf, FrameSlot sf) {
            this.pf = pf;
            this.zf = zf;
            this.sf = sf;
        }

        public void execute(VirtualFrame frame, byte value) {
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, short value) {
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, int value) {
            frame.setBoolean(this.sf, value < 0);
            frame.setBoolean(this.zf, value == 0);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSFlagsNode.getParity(value));
        }

        public void execute(VirtualFrame frame, long value) {
            frame.setBoolean(this.sf, value < 0L);
            frame.setBoolean(this.zf, value == 0L);
            frame.setBoolean(this.pf, LLVMAMD64UpdatePZSFlagsNode.getParity(value));
        }
    }
}

