/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64CmpXchgNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.op.ToComparableValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LLVMAMD64CmpXchgNode.class)
public final class LLVMAMD64CmpXchgNodeFactory {

    @GeneratedBy(value=LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgqNode.class)
    public static final class LLVMAMD64CmpXchgqNodeGen
    extends LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgqNode {
        @Node.Child
        private LLVMExpressionNode a_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private ToComparableValue op2_toComparableA_;
        @Node.Child
        private ToComparableValue op2_toComparableB_;

        private LLVMAMD64CmpXchgqNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(flags, dst1, dst2);
            this.a_ = a;
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 6) == 0 && state != 0) {
                this.execute_long_long_long0(frameValue, state);
                return;
            }
            this.execute_generic1(frameValue, state);
        }

        private void execute_long_long_long0(VirtualFrame frameValue, int state) {
            long dstValue_;
            long srcValue_;
            long aValue_;
            try {
                aValue_ = this.a_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object srcValue = this.src_.executeGeneric(frameValue);
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), srcValue, dstValue);
                return;
            }
            try {
                srcValue_ = this.src_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, aValue_, ex.getResult(), dstValue);
                return;
            }
            try {
                dstValue_ = this.dst_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, aValue_, srcValue_, ex.getResult());
                return;
            }
            assert ((state & 1) != 0);
            this.doOp(frameValue, aValue_, srcValue_, dstValue_);
        }

        private void execute_generic1(VirtualFrame frameValue, int state) {
            Object aValue_ = this.a_.executeGeneric(frameValue);
            Object srcValue_ = this.src_.executeGeneric(frameValue);
            Object dstValue_ = this.dst_.executeGeneric(frameValue);
            if ((state & 1) != 0 && aValue_ instanceof Long) {
                long aValue__ = (Long)aValue_;
                if (srcValue_ instanceof Long) {
                    long srcValue__ = (Long)srcValue_;
                    if (dstValue_ instanceof Long) {
                        long dstValue__ = (Long)dstValue_;
                        this.doOp(frameValue, aValue__, srcValue__, dstValue__);
                        return;
                    }
                }
            }
            if ((state & 6) != 0 && LLVMTypes.isNativePointer(srcValue_)) {
                LLVMPointer aValue__;
                LLVMNativePointer srcValue__ = LLVMTypes.asNativePointer(srcValue_);
                if ((state & 2) != 0 && LLVMTypes.isNativePointer(aValue_)) {
                    aValue__ = LLVMTypes.asNativePointer(aValue_);
                    if (LLVMTypes.isNativePointer(dstValue_)) {
                        LLVMNativePointer dstValue__ = LLVMTypes.asNativePointer(dstValue_);
                        this.doOp(frameValue, (LLVMNativePointer)aValue__, srcValue__, dstValue__);
                        return;
                    }
                }
                if ((state & 4) != 0 && LLVMTypes.isManagedPointer(aValue_)) {
                    aValue__ = LLVMTypes.asManagedPointer(aValue_);
                    if (LLVMTypes.isManagedPointer(dstValue_)) {
                        LLVMManagedPointer dstValue__ = LLVMTypes.asManagedPointer(dstValue_);
                        this.doOp(frameValue, (LLVMManagedPointer)aValue__, srcValue__, dstValue__, this.op2_toComparableA_, this.op2_toComparableB_);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, aValue_, srcValue_, dstValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object aValue, Object srcValue, Object dstValue) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (aValue instanceof Long) {
                    long aValue_ = (Long)aValue;
                    if (srcValue instanceof Long) {
                        long srcValue_ = (Long)srcValue;
                        if (dstValue instanceof Long) {
                            long dstValue_ = (Long)dstValue;
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                            return;
                        }
                    }
                }
                if (LLVMTypes.isNativePointer(srcValue)) {
                    LLVMPointer aValue_;
                    LLVMNativePointer srcValue_ = LLVMTypes.asNativePointer(srcValue);
                    if (LLVMTypes.isNativePointer(aValue)) {
                        aValue_ = LLVMTypes.asNativePointer(aValue);
                        if (LLVMTypes.isNativePointer(dstValue)) {
                            LLVMNativePointer dstValue_ = LLVMTypes.asNativePointer(dstValue);
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            this.doOp(frameValue, (LLVMNativePointer)aValue_, srcValue_, dstValue_);
                            return;
                        }
                    }
                    if (LLVMTypes.isManagedPointer(aValue)) {
                        aValue_ = LLVMTypes.asManagedPointer(aValue);
                        if (LLVMTypes.isManagedPointer(dstValue)) {
                            LLVMManagedPointer dstValue_ = LLVMTypes.asManagedPointer(dstValue);
                            this.op2_toComparableA_ = (ToComparableValue)super.insert((Node)LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgqNode.createToComparable());
                            this.op2_toComparableB_ = (ToComparableValue)super.insert((Node)LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgqNode.createToComparable());
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            this.doOp(frameValue, (LLVMManagedPointer)aValue_, srcValue_, dstValue_, this.op2_toComparableA_, this.op2_toComparableB_);
                            return;
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.a_, this.src_, this.dst_}, new Object[]{aValue, srcValue, dstValue});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgqNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64CmpXchgqNodeGen(flags, dst1, dst2, a, src, dst);
        }
    }

    @GeneratedBy(value=LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchglNode.class)
    public static final class LLVMAMD64CmpXchglNodeGen
    extends LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchglNode {
        @Node.Child
        private LLVMExpressionNode a_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64CmpXchglNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(flags, dst1, dst2);
            this.a_ = a;
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            int dstValue_;
            int srcValue_;
            int aValue_;
            int state = this.state_;
            try {
                aValue_ = this.a_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object srcValue = this.src_.executeGeneric(frameValue);
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), srcValue, dstValue);
                return;
            }
            try {
                srcValue_ = this.src_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, aValue_, ex.getResult(), dstValue);
                return;
            }
            try {
                dstValue_ = this.dst_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, aValue_, srcValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, aValue_, srcValue_, dstValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object aValue, Object srcValue, Object dstValue) {
            int state = this.state_;
            if (aValue instanceof Integer) {
                int aValue_ = (Integer)aValue;
                if (srcValue instanceof Integer) {
                    int srcValue_ = (Integer)srcValue;
                    if (dstValue instanceof Integer) {
                        int dstValue_ = (Integer)dstValue;
                        this.state_ = state |= 1;
                        this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.a_, this.src_, this.dst_}, new Object[]{aValue, srcValue, dstValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchglNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64CmpXchglNodeGen(flags, dst1, dst2, a, src, dst);
        }
    }

    @GeneratedBy(value=LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgwNode.class)
    public static final class LLVMAMD64CmpXchgwNodeGen
    extends LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgwNode {
        @Node.Child
        private LLVMExpressionNode a_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64CmpXchgwNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(flags, dst1, dst2);
            this.a_ = a;
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short dstValue_;
            short srcValue_;
            short aValue_;
            int state = this.state_;
            try {
                aValue_ = this.a_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object srcValue = this.src_.executeGeneric(frameValue);
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), srcValue, dstValue);
                return;
            }
            try {
                srcValue_ = this.src_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, aValue_, ex.getResult(), dstValue);
                return;
            }
            try {
                dstValue_ = this.dst_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, aValue_, srcValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, aValue_, srcValue_, dstValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object aValue, Object srcValue, Object dstValue) {
            int state = this.state_;
            if (aValue instanceof Short) {
                short aValue_ = (Short)aValue;
                if (srcValue instanceof Short) {
                    short srcValue_ = (Short)srcValue;
                    if (dstValue instanceof Short) {
                        short dstValue_ = (Short)dstValue;
                        this.state_ = state |= 1;
                        this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.a_, this.src_, this.dst_}, new Object[]{aValue, srcValue, dstValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgwNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64CmpXchgwNodeGen(flags, dst1, dst2, a, src, dst);
        }
    }

    @GeneratedBy(value=LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgbNode.class)
    public static final class LLVMAMD64CmpXchgbNodeGen
    extends LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgbNode {
        @Node.Child
        private LLVMExpressionNode a_;
        @Node.Child
        private LLVMExpressionNode src_;
        @Node.Child
        private LLVMExpressionNode dst_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private LLVMAMD64CmpXchgbNodeGen(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            super(flags, dst1, dst2);
            this.a_ = a;
            this.src_ = src;
            this.dst_ = dst;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte dstValue_;
            byte srcValue_;
            byte aValue_;
            int state = this.state_;
            try {
                aValue_ = this.a_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object srcValue = this.src_.executeGeneric(frameValue);
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, ex.getResult(), srcValue, dstValue);
                return;
            }
            try {
                srcValue_ = this.src_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object dstValue = this.dst_.executeGeneric(frameValue);
                this.executeAndSpecialize(frameValue, aValue_, ex.getResult(), dstValue);
                return;
            }
            try {
                dstValue_ = this.dst_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.executeAndSpecialize(frameValue, aValue_, srcValue_, ex.getResult());
                return;
            }
            if (state != 0) {
                this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, aValue_, srcValue_, dstValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object aValue, Object srcValue, Object dstValue) {
            int state = this.state_;
            if (aValue instanceof Byte) {
                byte aValue_ = (Byte)aValue;
                if (srcValue instanceof Byte) {
                    byte srcValue_ = (Byte)srcValue;
                    if (dstValue instanceof Byte) {
                        byte dstValue_ = (Byte)dstValue;
                        this.state_ = state |= 1;
                        this.doOp(frameValue, aValue_, srcValue_, dstValue_);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.a_, this.src_, this.dst_}, new Object[]{aValue, srcValue, dstValue});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static LLVMAMD64CmpXchgNode.LLVMAMD64CmpXchgbNode create(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPAZSOFlagsNode flags, LLVMAMD64WriteValueNode dst1, LLVMAMD64WriteValueNode dst2, LLVMExpressionNode a, LLVMExpressionNode src, LLVMExpressionNode dst) {
            return new LLVMAMD64CmpXchgbNodeGen(flags, dst1, dst2, a, src, dst);
        }
    }
}

