/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;

@GeneratedBy(value=LLVMTypes.class)
public final class LLVMTypesGen
extends LLVMTypes {
    @Deprecated
    public static final LLVMTypesGen L_L_V_M_TYPES = new LLVMTypesGen();

    protected LLVMTypesGen() {
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean asBoolean(Object value) {
        assert (value instanceof Boolean) : "LLVMTypesGen.asBoolean: boolean expected";
        return (Boolean)value;
    }

    public static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isByte(Object value) {
        return value instanceof Byte;
    }

    public static byte asByte(Object value) {
        assert (value instanceof Byte) : "LLVMTypesGen.asByte: byte expected";
        return (Byte)value;
    }

    public static byte expectByte(Object value) throws UnexpectedResultException {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isShort(Object value) {
        return value instanceof Short;
    }

    public static short asShort(Object value) {
        assert (value instanceof Short) : "LLVMTypesGen.asShort: short expected";
        return (Short)value;
    }

    public static short expectShort(Object value) throws UnexpectedResultException {
        if (value instanceof Short) {
            return (Short)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer;
    }

    public static int asInteger(Object value) {
        assert (value instanceof Integer) : "LLVMTypesGen.asInteger: int expected";
        return (Integer)value;
    }

    public static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isCharacter(Object value) {
        return value instanceof Character;
    }

    public static char asCharacter(Object value) {
        assert (value instanceof Character) : "LLVMTypesGen.asCharacter: char expected";
        return ((Character)value).charValue();
    }

    public static char expectCharacter(Object value) throws UnexpectedResultException {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLong(Object value) {
        return value instanceof Long;
    }

    public static long asLong(Object value) {
        assert (value instanceof Long) : "LLVMTypesGen.asLong: long expected";
        return (Long)value;
    }

    public static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isDouble(Object value) {
        return value instanceof Double;
    }

    public static double asDouble(Object value) {
        assert (value instanceof Double) : "LLVMTypesGen.asDouble: double expected";
        return (Double)value;
    }

    public static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isFloat(Object value) {
        return value instanceof Float;
    }

    public static float asFloat(Object value) {
        assert (value instanceof Float) : "LLVMTypesGen.asFloat: float expected";
        return ((Float)value).floatValue();
    }

    public static float expectFloat(Object value) throws UnexpectedResultException {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isByteArray(Object value) {
        return value instanceof byte[];
    }

    public static byte[] asByteArray(Object value) {
        assert (value instanceof byte[]) : "LLVMTypesGen.asByteArray: byte[] expected";
        return (byte[])value;
    }

    public static byte[] expectByteArray(Object value) throws UnexpectedResultException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI1Vector(Object value) {
        return value instanceof LLVMI1Vector;
    }

    public static LLVMI1Vector asLLVMI1Vector(Object value) {
        assert (value instanceof LLVMI1Vector) : "LLVMTypesGen.asLLVMI1Vector: LLVMI1Vector expected";
        return (LLVMI1Vector)value;
    }

    public static LLVMI1Vector expectLLVMI1Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI1Vector) {
            return (LLVMI1Vector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI8Vector(Object value) {
        return value instanceof LLVMI8Vector;
    }

    public static LLVMI8Vector asLLVMI8Vector(Object value) {
        assert (value instanceof LLVMI8Vector) : "LLVMTypesGen.asLLVMI8Vector: LLVMI8Vector expected";
        return (LLVMI8Vector)value;
    }

    public static LLVMI8Vector expectLLVMI8Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI8Vector) {
            return (LLVMI8Vector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI16Vector(Object value) {
        return value instanceof LLVMI16Vector;
    }

    public static LLVMI16Vector asLLVMI16Vector(Object value) {
        assert (value instanceof LLVMI16Vector) : "LLVMTypesGen.asLLVMI16Vector: LLVMI16Vector expected";
        return (LLVMI16Vector)value;
    }

    public static LLVMI16Vector expectLLVMI16Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI16Vector) {
            return (LLVMI16Vector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI32Vector(Object value) {
        return value instanceof LLVMI32Vector;
    }

    public static LLVMI32Vector asLLVMI32Vector(Object value) {
        assert (value instanceof LLVMI32Vector) : "LLVMTypesGen.asLLVMI32Vector: LLVMI32Vector expected";
        return (LLVMI32Vector)value;
    }

    public static LLVMI32Vector expectLLVMI32Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI32Vector) {
            return (LLVMI32Vector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMI64Vector(Object value) {
        return value instanceof LLVMI64Vector;
    }

    public static LLVMI64Vector asLLVMI64Vector(Object value) {
        assert (value instanceof LLVMI64Vector) : "LLVMTypesGen.asLLVMI64Vector: LLVMI64Vector expected";
        return (LLVMI64Vector)value;
    }

    public static LLVMI64Vector expectLLVMI64Vector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMI64Vector) {
            return (LLVMI64Vector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMPointerVector(Object value) {
        return value instanceof LLVMPointerVector;
    }

    public static LLVMPointerVector asLLVMPointerVector(Object value) {
        assert (value instanceof LLVMPointerVector) : "LLVMTypesGen.asLLVMPointerVector: LLVMPointerVector expected";
        return (LLVMPointerVector)value;
    }

    public static LLVMPointerVector expectLLVMPointerVector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMPointerVector) {
            return (LLVMPointerVector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMFloatVector(Object value) {
        return value instanceof LLVMFloatVector;
    }

    public static LLVMFloatVector asLLVMFloatVector(Object value) {
        assert (value instanceof LLVMFloatVector) : "LLVMTypesGen.asLLVMFloatVector: LLVMFloatVector expected";
        return (LLVMFloatVector)value;
    }

    public static LLVMFloatVector expectLLVMFloatVector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMFloatVector) {
            return (LLVMFloatVector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVMDoubleVector(Object value) {
        return value instanceof LLVMDoubleVector;
    }

    public static LLVMDoubleVector asLLVMDoubleVector(Object value) {
        assert (value instanceof LLVMDoubleVector) : "LLVMTypesGen.asLLVMDoubleVector: LLVMDoubleVector expected";
        return (LLVMDoubleVector)value;
    }

    public static LLVMDoubleVector expectLLVMDoubleVector(Object value) throws UnexpectedResultException {
        if (value instanceof LLVMDoubleVector) {
            return (LLVMDoubleVector)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static LLVMNativePointer expectLLVMNativePointer(Object value) throws UnexpectedResultException {
        if (LLVMTypes.isNativePointer(value)) {
            return LLVMTypes.asNativePointer(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static LLVMManagedPointer expectLLVMManagedPointer(Object value) throws UnexpectedResultException {
        if (LLVMTypes.isManagedPointer(value)) {
            return LLVMTypes.asManagedPointer(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static LLVMPointer expectLLVMPointer(Object value) throws UnexpectedResultException {
        if (LLVMTypes.isPointer(value)) {
            return LLVMTypes.asPointer(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static LLVMIVarBit expectLLVMIVarBit(Object value) throws UnexpectedResultException {
        if (LLVMTypes.isLLVMIVarBit(value)) {
            return LLVMTypes.asLLVMIVarBit(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isLLVM80BitFloat(Object value) {
        return value instanceof LLVM80BitFloat;
    }

    public static LLVM80BitFloat asLLVM80BitFloat(Object value) {
        assert (value instanceof LLVM80BitFloat) : "LLVMTypesGen.asLLVM80BitFloat: LLVM80BitFloat expected";
        return (LLVM80BitFloat)value;
    }

    public static LLVM80BitFloat expectLLVM80BitFloat(Object value) throws UnexpectedResultException {
        if (value instanceof LLVM80BitFloat) {
            return (LLVM80BitFloat)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isTruffleObject(Object value) {
        return value instanceof TruffleObject;
    }

    public static TruffleObject asTruffleObject(Object value) {
        assert (value instanceof TruffleObject) : "LLVMTypesGen.asTruffleObject: TruffleObject expected";
        return (TruffleObject)value;
    }

    public static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
        if (value instanceof TruffleObject) {
            return (TruffleObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static LLVMIVarBit expectImplicitLLVMIVarBit(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && LLVMTypes.isLLVMIVarBit(value)) {
            return LLVMTypes.asLLVMIVarBit(value);
        }
        if ((state & 2) != 0 && LLVMTypes.isLLVMIVarBitSmall(value)) {
            return LLVMTypesGen.asIVarBit(LLVMTypes.asLLVMIVarBitSmall(value));
        }
        if ((state & 4) != 0 && LLVMTypes.isLLVMIVarBitLarge(value)) {
            return LLVMTypesGen.asIVarBit(LLVMTypes.asLLVMIVarBitLarge(value));
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitLLVMIVarBit(int state, Object value) {
        return (state & 1) != 0 && LLVMTypes.isLLVMIVarBit(value) || (state & 2) != 0 && LLVMTypes.isLLVMIVarBitSmall(value) || (state & 4) != 0 && LLVMTypes.isLLVMIVarBitLarge(value);
    }

    public static boolean isImplicitLLVMIVarBit(Object value) {
        return LLVMTypes.isLLVMIVarBit(value) || LLVMTypes.isLLVMIVarBitSmall(value) || LLVMTypes.isLLVMIVarBitLarge(value);
    }

    public static LLVMIVarBit asImplicitLLVMIVarBit(int state, Object value) {
        if ((state & 1) != 0 && LLVMTypes.isLLVMIVarBit(value)) {
            return LLVMTypes.asLLVMIVarBit(value);
        }
        if ((state & 2) != 0 && LLVMTypes.isLLVMIVarBitSmall(value)) {
            return LLVMTypesGen.asIVarBit(LLVMTypes.asLLVMIVarBitSmall(value));
        }
        if ((state & 4) != 0 && LLVMTypes.isLLVMIVarBitLarge(value)) {
            return LLVMTypesGen.asIVarBit(LLVMTypes.asLLVMIVarBitLarge(value));
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static LLVMIVarBit asImplicitLLVMIVarBit(Object value) {
        if (LLVMTypes.isLLVMIVarBit(value)) {
            return LLVMTypes.asLLVMIVarBit(value);
        }
        if (LLVMTypes.isLLVMIVarBitSmall(value)) {
            return LLVMTypesGen.asIVarBit(LLVMTypes.asLLVMIVarBitSmall(value));
        }
        if (LLVMTypes.isLLVMIVarBitLarge(value)) {
            return LLVMTypesGen.asIVarBit(LLVMTypes.asLLVMIVarBitLarge(value));
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitLLVMIVarBit(Object value) {
        if (LLVMTypes.isLLVMIVarBit(value)) {
            return 1;
        }
        if (LLVMTypes.isLLVMIVarBitSmall(value)) {
            return 2;
        }
        if (LLVMTypes.isLLVMIVarBitLarge(value)) {
            return 4;
        }
        return 0;
    }
}

