/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNodeSourceDescriptor;

public abstract class LLVMInstrumentableNode
extends LLVMNode
implements InstrumentableNode {
    @CompilerDirectives.CompilationFinal
    private LLVMNodeSourceDescriptor sourceDescriptor = null;

    public final LLVMNodeSourceDescriptor getSourceDescriptor() {
        return this.sourceDescriptor;
    }

    public final LLVMNodeSourceDescriptor getOrCreateSourceDescriptor() {
        if (this.sourceDescriptor == null) {
            this.setSourceDescriptor(new LLVMNodeSourceDescriptor());
        }
        return this.sourceDescriptor;
    }

    public final void setSourceDescriptor(LLVMNodeSourceDescriptor sourceDescriptor) {
        CompilerAsserts.neverPartOfCompilation();
        this.sourceDescriptor = sourceDescriptor;
    }

    public SourceSection getSourceSection() {
        return this.sourceDescriptor != null ? this.sourceDescriptor.getSourceSection() : null;
    }

    public boolean isInstrumentable() {
        return this.getSourceSection() != null;
    }

    private boolean hasStatementTag() {
        return this.sourceDescriptor != null && this.sourceDescriptor.hasStatementTag();
    }

    public LLVMSourceLocation getSourceLocation() {
        return this.sourceDescriptor != null ? this.sourceDescriptor.getSourceLocation() : null;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == StandardTags.StatementTag.class) {
            return this.hasStatementTag();
        }
        return false;
    }
}

