/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class UnsafeArrayAccess
implements LLVMCapability {
    private static final Unsafe unsafe = UnsafeArrayAccess.getUnsafe();
    private static final UnsafeArrayAccess INSTANCE = new UnsafeArrayAccess();

    @Deprecated
    public static UnsafeArrayAccess getInstance() {
        return INSTANCE;
    }

    private UnsafeArrayAccess() {
    }

    private static Unsafe getUnsafe() {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new AssertionError();
        }
    }

    public void writeI1(int[] arr, long offset, boolean value) {
        this.writeI1(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public boolean getI1(int[] arr, long offset) {
        return this.getI1(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeI8(int[] arr, long offset, byte value) {
        this.writeI8(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public byte getI8(int[] arr, long offset) {
        return this.getI8(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeI16(int[] arr, long offset, short value) {
        this.writeI16(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public short getI16(int[] arr, long offset) {
        return this.getI16(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeI32(int[] arr, long offset, int value) {
        this.writeI32(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public int getI32(int[] arr, long offset) {
        return this.getI32(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeI64(int[] arr, long offset, long value) {
        this.writeI64(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public long getI64(int[] arr, long offset) {
        return this.getI64(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeFloat(int[] arr, long offset, float value) {
        this.writeFloat(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public float getFloat(int[] arr, long offset) {
        return this.getFloat(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeDouble(int[] arr, long offset, double value) {
        this.writeDouble(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset, value);
    }

    public double getDouble(int[] arr, long offset) {
        return this.getDouble(arr, Unsafe.ARRAY_INT_BASE_OFFSET, offset);
    }

    public void writeI1(long[] arr, long offset, boolean value) {
        this.writeI1(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public boolean getI1(long[] arr, long offset) {
        return this.getI1(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeI8(long[] arr, long offset, byte value) {
        this.writeI8(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public byte getI8(long[] arr, long offset) {
        return this.getI8(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeI16(long[] arr, long offset, short value) {
        this.writeI16(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public short getI16(long[] arr, long offset) {
        return this.getI16(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeI32(long[] arr, long offset, int value) {
        this.writeI32(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public int getI32(long[] arr, long offset) {
        return this.getI32(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeI64(long[] arr, long offset, long value) {
        this.writeI64(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public long getI64(long[] arr, long offset) {
        return this.getI64(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeFloat(long[] arr, long offset, float value) {
        this.writeFloat(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public float getFloat(long[] arr, long offset) {
        return this.getFloat(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeDouble(long[] arr, long offset, double value) {
        this.writeDouble(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset, value);
    }

    public double getDouble(long[] arr, long offset) {
        return this.getDouble(arr, Unsafe.ARRAY_LONG_BASE_OFFSET, offset);
    }

    public void writeI1(Object arr, long baseOffset, long offset, boolean value) {
        assert (this.inBounds(arr, offset, 1));
        unsafe.putByte(arr, baseOffset + offset, (byte)(value ? 1 : 0));
    }

    public boolean getI1(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 1));
        return unsafe.getByte(arr, baseOffset + offset) != 0;
    }

    public void writeI8(Object arr, long baseOffset, long offset, byte value) {
        assert (this.inBounds(arr, offset, 1));
        unsafe.putByte(arr, baseOffset + offset, value);
    }

    public byte getI8(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 1));
        return unsafe.getByte(arr, baseOffset + offset);
    }

    public void writeI16(Object arr, long baseOffset, long offset, short value) {
        assert (this.inBounds(arr, offset, 2));
        unsafe.putShort(arr, baseOffset + offset, value);
    }

    public short getI16(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 2));
        return unsafe.getShort(arr, baseOffset + offset);
    }

    public void writeI32(Object arr, long baseOffset, long offset, int value) {
        assert (this.inBounds(arr, offset, 4));
        unsafe.putInt(arr, baseOffset + offset, value);
    }

    public int getI32(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 4));
        return unsafe.getInt(arr, baseOffset + offset);
    }

    public void writeI64(Object arr, long baseOffset, long offset, long value) {
        assert (this.inBounds(arr, offset, 8));
        unsafe.putLong(arr, baseOffset + offset, value);
    }

    public long getI64(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 8));
        return unsafe.getLong(arr, baseOffset + offset);
    }

    public void writeFloat(Object arr, long baseOffset, long offset, float value) {
        assert (this.inBounds(arr, offset, 4));
        unsafe.putFloat(arr, baseOffset + offset, value);
    }

    public float getFloat(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 4));
        return unsafe.getFloat(arr, baseOffset + offset);
    }

    public void writeDouble(Object arr, long baseOffset, long offset, double value) {
        assert (this.inBounds(arr, offset, 8));
        unsafe.putDouble(arr, baseOffset + offset, value);
    }

    public double getDouble(Object arr, long baseOffset, long offset) {
        assert (this.inBounds(arr, offset, 8));
        return unsafe.getDouble(arr, baseOffset + offset);
    }

    private boolean inBounds(Object arr, long offset, int accessedBytes) {
        assert (accessedBytes > 0);
        long arraySize = (long)Array.getLength(arr) * (long)this.getArrayElementSize(arr);
        return offset >= 0L && offset + (long)accessedBytes <= arraySize;
    }

    private int getArrayElementSize(Object arr) {
        assert (arr.getClass().isArray());
        Class<?> componentType = arr.getClass().getComponentType();
        if (componentType == Boolean.TYPE || componentType == Byte.TYPE) {
            return 1;
        }
        if (componentType == Short.TYPE) {
            return 2;
        }
        if (componentType == Integer.TYPE) {
            return 4;
        }
        if (componentType == Long.TYPE) {
            return 8;
        }
        if (componentType == Float.TYPE) {
            return 4;
        }
        if (componentType == Double.TYPE) {
            return 8;
        }
        throw new IllegalStateException("Unexpected type: " + componentType);
    }
}

