/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;

public final class LLVMStack {
    public static final String FRAME_ID = "<stackpointer>";
    private final long stackSize;
    private long lowerBounds;
    private long upperBounds;
    private boolean isAllocated;
    private long stackPointer;
    private long uniquesRegionPointer;
    public static final int NO_ALIGNMENT_REQUIREMENTS = 1;

    public LLVMStack(long stackSize) {
        this.stackSize = stackSize;
        this.lowerBounds = 0L;
        this.upperBounds = 0L;
        this.stackPointer = 0L;
        this.uniquesRegionPointer = 0L;
        this.isAllocated = false;
    }

    @CompilerDirectives.TruffleBoundary
    private void allocate(LLVMMemory memory) {
        long stackAllocation;
        long size = this.stackSize;
        this.lowerBounds = stackAllocation = memory.allocateMemory(size).asNative();
        this.upperBounds = stackAllocation + size;
        this.isAllocated = true;
        this.stackPointer = this.upperBounds;
    }

    private long getStackPointer(LLVMMemory memory) {
        if (!this.isAllocated) {
            CompilerDirectives.transferToInterpreter();
            this.allocate(memory);
        }
        return this.stackPointer;
    }

    public StackPointer newFrame() {
        return new StackPointer(this.stackPointer, this.uniquesRegionPointer);
    }

    @CompilerDirectives.TruffleBoundary
    public void free(LLVMMemory memory) {
        if (this.isAllocated) {
            memory.free(this.lowerBounds);
            this.lowerBounds = 0L;
            this.upperBounds = 0L;
            this.stackPointer = 0L;
            this.isAllocated = false;
        }
    }

    public static long allocateStackMemory(VirtualFrame frame, LLVMMemory memory, FrameSlot stackPointerSlot, long size, int alignment) {
        StackPointer basePointer = (StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)stackPointerSlot);
        long stackPointer = basePointer.get(memory);
        assert (stackPointer != 0L);
        long alignedAllocation = LLVMStack.getAlignedAllocation(stackPointer, size, alignment);
        basePointer.set(alignedAllocation);
        return alignedAllocation;
    }

    private static long getAlignedAllocation(long address, long size, int alignment) {
        assert (size >= 0L);
        assert (alignment != 0 && LLVMStack.powerOfTwo(alignment));
        long alignedAllocation = address - size & (long)(-alignment);
        assert (alignedAllocation <= address);
        return alignedAllocation;
    }

    private static boolean powerOfTwo(int value) {
        return (value & -value) == value;
    }

    public static final class UniquesRegion {
        private long currentSlotPointer = 0L;
        private int alignment = 1;

        public UniqueSlot addSlot(int slotSize, int slotAlignment) {
            CompilerAsserts.neverPartOfCompilation();
            this.currentSlotPointer = LLVMStack.getAlignedAllocation(this.currentSlotPointer, slotSize, slotAlignment);
            this.alignment = Integer.highestOneBit(this.alignment | slotAlignment | Integer.highestOneBit(slotSize) << 1);
            return new UniqueSlot(this.currentSlotPointer);
        }

        public UniquesRegionAllocator build() {
            return new UniquesRegionAllocator(-this.currentSlotPointer, this.alignment);
        }

        public static final class UniqueSlot {
            private final long address;

            private UniqueSlot(long address) {
                this.address = address;
            }

            public long toPointer(VirtualFrame frame, FrameSlot stackPointerSlot) {
                StackPointer basePointer = (StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)stackPointerSlot);
                long uniquesRegionPointer = basePointer.getUniquesRegionPointer();
                assert (uniquesRegionPointer != 0L);
                return uniquesRegionPointer + this.address;
            }
        }

        public static final class UniquesRegionAllocator {
            private final long uniquesRegionSize;
            private final int uniquesRegionAlignment;

            private UniquesRegionAllocator(long uniquesRegionSize, int uniquesRegionAlignment) {
                this.uniquesRegionSize = uniquesRegionSize;
                this.uniquesRegionAlignment = uniquesRegionAlignment;
            }

            void allocate(VirtualFrame frame, LLVMMemory memory, FrameSlot stackPointerSlot) {
                if (this.uniquesRegionSize == 0L) {
                    return;
                }
                StackPointer basePointer = (StackPointer)FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)stackPointerSlot);
                long stackPointer = basePointer.get(memory);
                assert (stackPointer != 0L);
                long uniquesRegionPointer = this.getAlignedBasePointer(stackPointer);
                basePointer.setUniquesRegionPointer(uniquesRegionPointer);
                long alignedAllocation = LLVMStack.getAlignedAllocation(uniquesRegionPointer, this.uniquesRegionSize, 1);
                basePointer.set(alignedAllocation);
            }

            long getAlignedBasePointer(long address) {
                assert (this.uniquesRegionAlignment != 0 && LLVMStack.powerOfTwo(this.uniquesRegionAlignment));
                return address & (long)(-this.uniquesRegionAlignment);
            }
        }
    }

    public final class StackPointer
    implements AutoCloseable {
        private long basePointer;
        private final long uniquesRegionBasePointer;

        private StackPointer(long basePointer, long uniquesRegionBasePointer) {
            this.basePointer = basePointer;
            this.uniquesRegionBasePointer = uniquesRegionBasePointer;
        }

        public long get(LLVMMemory memory) {
            if (this.basePointer == 0L) {
                this.basePointer = LLVMStack.this.getStackPointer(memory);
                LLVMStack.this.stackPointer = this.basePointer;
            }
            return LLVMStack.this.stackPointer;
        }

        public void set(long sp) {
            LLVMStack.this.stackPointer = sp;
        }

        public long getUniquesRegionPointer() {
            return LLVMStack.this.uniquesRegionPointer;
        }

        public void setUniquesRegionPointer(long urp) {
            LLVMStack.this.uniquesRegionPointer = urp;
        }

        @Override
        public void close() {
            if (this.basePointer != 0L) {
                LLVMStack.this.stackPointer = this.basePointer;
                LLVMStack.this.uniquesRegionPointer = this.uniquesRegionBasePointer;
            }
        }

        public StackPointer newFrame() {
            return new StackPointer(LLVMStack.this.stackPointer, LLVMStack.this.uniquesRegionPointer);
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return String.format("StackPointer 0x%x (Bounds: 0x%x - 0x%x%s)", LLVMStack.this.stackPointer, LLVMStack.this.lowerBounds, LLVMStack.this.upperBounds, LLVMStack.this.isAllocated ? "" : " not allocated");
        }
    }
}

