/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;

public abstract class LLVMMemory
implements LLVMCapability {
    @Deprecated
    public abstract void memset(LLVMNativePointer var1, long var2, byte var4);

    @Deprecated
    public abstract void copyMemory(long var1, long var3, long var5);

    public final void free(LLVMNativePointer address) {
        this.free(address.asNative());
    }

    public abstract void free(long var1);

    public abstract LLVMNativePointer allocateMemory(long var1);

    @Deprecated
    public abstract LLVMNativePointer reallocateMemory(LLVMNativePointer var1, long var2);

    public final boolean getI1(LLVMNativePointer addr) {
        return this.getI1(addr.asNative());
    }

    public abstract boolean getI1(long var1);

    public final byte getI8(LLVMNativePointer addr) {
        return this.getI8(addr.asNative());
    }

    public abstract byte getI8(long var1);

    public final short getI16(LLVMNativePointer addr) {
        return this.getI16(addr.asNative());
    }

    public abstract short getI16(long var1);

    public final int getI32(LLVMNativePointer addr) {
        return this.getI32(addr.asNative());
    }

    public abstract int getI32(long var1);

    public abstract LLVMIVarBit getIVarBit(LLVMNativePointer var1, int var2);

    public final long getI64(LLVMNativePointer addr) {
        return this.getI64(addr.asNative());
    }

    public abstract long getI64(long var1);

    public final float getFloat(LLVMNativePointer addr) {
        return this.getFloat(addr.asNative());
    }

    public abstract float getFloat(long var1);

    public final double getDouble(LLVMNativePointer addr) {
        return this.getDouble(addr.asNative());
    }

    public abstract double getDouble(long var1);

    public abstract LLVM80BitFloat get80BitFloat(LLVMNativePointer var1);

    public final LLVMNativePointer getPointer(LLVMNativePointer addr) {
        return this.getPointer(addr.asNative());
    }

    public abstract LLVMNativePointer getPointer(long var1);

    public final void putI1(LLVMNativePointer addr, boolean value) {
        this.putI1(addr.asNative(), value);
    }

    public abstract void putI1(long var1, boolean var3);

    public final void putI8(LLVMNativePointer addr, byte value) {
        this.putI8(addr.asNative(), value);
    }

    public abstract void putI8(long var1, byte var3);

    public final void putI16(LLVMNativePointer addr, short value) {
        this.putI16(addr.asNative(), value);
    }

    public abstract void putI16(long var1, short var3);

    public final void putI32(LLVMNativePointer addr, int value) {
        this.putI32(addr.asNative(), value);
    }

    public abstract void putI32(long var1, int var3);

    public final void putI64(LLVMNativePointer addr, long value) {
        this.putI64(addr.asNative(), value);
    }

    public abstract void putI64(long var1, long var3);

    public abstract void putIVarBit(LLVMNativePointer var1, LLVMIVarBit var2);

    public final void putFloat(LLVMNativePointer addr, float value) {
        this.putFloat(addr.asNative(), value);
    }

    public abstract void putFloat(long var1, float var3);

    public final void putDouble(LLVMNativePointer addr, double value) {
        this.putDouble(addr.asNative(), value);
    }

    public abstract void putDouble(long var1, double var3);

    public final void put80BitFloat(LLVMNativePointer addr, LLVM80BitFloat value) {
        this.put80BitFloat(addr.asNative(), value);
    }

    public abstract void put80BitFloat(long var1, LLVM80BitFloat var3);

    public final void putPointer(LLVMNativePointer addr, LLVMNativePointer value) {
        this.putPointer(addr.asNative(), value.asNative());
    }

    public final void putPointer(LLVMNativePointer addr, long ptrValue) {
        this.putPointer(addr.asNative(), ptrValue);
    }

    public final void putPointer(long ptr, LLVMNativePointer value) {
        this.putPointer(ptr, value.asNative());
    }

    public abstract void putPointer(long var1, long var3);

    public final void putByteArray(LLVMNativePointer addr, byte[] bytes) {
        this.putByteArray(addr.asNative(), bytes);
    }

    public abstract void putByteArray(long var1, byte[] var3);

    public abstract CMPXCHGI32 compareAndSwapI32(LLVMNativePointer var1, int var2, int var3);

    public abstract CMPXCHGI64 compareAndSwapI64(LLVMNativePointer var1, long var2, long var4);

    public abstract CMPXCHGI8 compareAndSwapI8(LLVMNativePointer var1, byte var2, byte var3);

    public abstract CMPXCHGI16 compareAndSwapI16(LLVMNativePointer var1, short var2, short var3);

    public abstract long getAndSetI64(LLVMNativePointer var1, long var2);

    public abstract long getAndAddI64(LLVMNativePointer var1, long var2);

    public abstract long getAndSubI64(LLVMNativePointer var1, long var2);

    public abstract long getAndOpI64(LLVMNativePointer var1, long var2, LongBinaryOperator var4);

    public abstract int getAndSetI32(LLVMNativePointer var1, int var2);

    public abstract int getAndAddI32(LLVMNativePointer var1, int var2);

    public abstract int getAndSubI32(LLVMNativePointer var1, int var2);

    public abstract int getAndOpI32(LLVMNativePointer var1, int var2, IntBinaryOperator var3);

    public abstract short getAndOpI16(LLVMNativePointer var1, short var2, ShortBinaryOperator var3);

    public abstract byte getAndOpI8(LLVMNativePointer var1, byte var2, ByteBinaryOperator var3);

    public abstract boolean getAndOpI1(LLVMNativePointer var1, boolean var2, BooleanBinaryOperator var3);

    public abstract void fullFence();

    public abstract long allocateHandle(boolean var1);

    public abstract boolean isHandleMemory(long var1);

    public abstract boolean isDerefHandleMemory(long var1);

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI64 {
        private final long value;
        private final boolean swap;

        public CMPXCHGI64(long value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public long getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI32 {
        private final int value;
        private final boolean swap;

        public CMPXCHGI32(int value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI16 {
        private final short value;
        private final boolean swap;

        public CMPXCHGI16(short value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public short getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @CompilerDirectives.ValueType
    public static final class CMPXCHGI8 {
        private final byte value;
        private final boolean swap;

        public CMPXCHGI8(byte value, boolean swap) {
            this.value = value;
            this.swap = swap;
        }

        public byte getValue() {
            return this.value;
        }

        public boolean isSwap() {
            return this.swap;
        }
    }

    @FunctionalInterface
    public static interface BooleanBinaryOperator {
        public boolean apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ByteBinaryOperator {
        public byte apply(byte var1, byte var2);
    }

    @FunctionalInterface
    public static interface ShortBinaryOperator {
        public short apply(short var1, short var2);
    }
}

