/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.memory.UnsafeArrayAccess;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.factories.LLVMObjectAccessFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

abstract class LLVMManagedAccessDefaults {
    LLVMManagedAccessDefaults() {
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=int[].class), @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=int[].class)})
    static class VirtualAlloc {
        VirtualAlloc() {
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
        static boolean isAccessible(int[] obj) {
            return true;
        }

        @ExportMessage
        static byte readI8(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI8(obj, offset);
        }

        @ExportMessage
        static short readI16(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI16(obj, offset);
        }

        @ExportMessage
        static int readI32(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI32(obj, offset);
        }

        @ExportMessage(name="readGenericI64")
        static long readI64(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getI64(obj, offset);
        }

        @ExportMessage
        static float readFloat(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getFloat(obj, offset);
        }

        @ExportMessage
        static double readDouble(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return language.getCapability(UnsafeArrayAccess.class).getDouble(obj, offset);
        }

        @ExportMessage
        static LLVMPointer readPointer(int[] obj, long offset, @CachedLanguage LLVMLanguage language) {
            return LLVMNativePointer.create(VirtualAlloc.readI64(obj, offset, language));
        }

        @ExportMessage
        static void writeI8(int[] obj, long offset, byte value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI8(obj, offset, value);
        }

        @ExportMessage
        static void writeI16(int[] obj, long offset, short value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI16(obj, offset, value);
        }

        @ExportMessage
        static void writeI32(int[] obj, long offset, int value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI32(obj, offset, value);
        }

        @ExportMessage
        static void writeI64(int[] obj, long offset, long value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeI64(obj, offset, value);
        }

        @ExportMessage
        static void writeFloat(int[] obj, long offset, float value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeFloat(obj, offset, value);
        }

        @ExportMessage
        static void writeDouble(int[] obj, long offset, double value, @CachedLanguage LLVMLanguage language) {
            language.getCapability(UnsafeArrayAccess.class).writeDouble(obj, offset, value);
        }

        @ExportMessage
        static class WriteGenericI64 {
            WriteGenericI64() {
            }

            @Specialization
            static void writeI64(int[] obj, long offset, long value, @CachedLanguage LLVMLanguage language) {
                language.getCapability(UnsafeArrayAccess.class).writeI64(obj, offset, value);
            }

            @Specialization(limit="3")
            static void writePointer(int[] obj, long offset, LLVMPointer value, @CachedLibrary(value="value") LLVMNativeLibrary nativeLib, @CachedLanguage LLVMLanguage language) {
                WriteGenericI64.writeI64(obj, offset, nativeLib.toNativePointer(value).asNative(), language);
            }
        }
    }

    @ExportLibrary(value=LLVMManagedWriteLibrary.class, receiverType=Object.class)
    @ImportStatic(value={LLVMObjectAccessFactory.class})
    static class FallbackWrite {
        FallbackWrite() {
        }

        @ExportMessage
        static boolean isWritable(Object obj, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            return write.canAccess(obj);
        }

        @ExportMessage
        static void writeI8(Object obj, long offset, byte value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I8);
        }

        @ExportMessage
        static void writeI16(Object obj, long offset, short value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I16);
        }

        @ExportMessage
        static void writeI32(Object obj, long offset, int value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I32);
        }

        @ExportMessage
        static void writeGenericI64(Object obj, long offset, Object value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.I64);
        }

        @ExportMessage
        static void writeFloat(Object obj, long offset, float value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, Float.valueOf(value), ForeignToLLVM.ForeignToLLVMType.FLOAT);
        }

        @ExportMessage
        static void writeDouble(Object obj, long offset, double value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.DOUBLE);
        }

        @ExportMessage
        static void writePointer(Object obj, long offset, LLVMPointer value, @Cached.Shared(value="write") @Cached(value="createWrite()", allowUncached=true) LLVMObjectAccess.LLVMObjectWriteNode write) {
            write.executeWrite(obj, offset, value, ForeignToLLVM.ForeignToLLVMType.POINTER);
        }
    }

    @ExportLibrary(value=LLVMManagedReadLibrary.class, receiverType=Object.class)
    @ImportStatic(value={LLVMObjectAccessFactory.class})
    static class FallbackRead {
        FallbackRead() {
        }

        @ExportMessage
        static boolean isReadable(Object obj, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return read.canAccess(obj);
        }

        @ExportMessage
        static byte readI8(Object obj, long offset, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return LLVMTypesGen.asByte(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I8));
        }

        @ExportMessage
        static short readI16(Object obj, long offset, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return LLVMTypesGen.asShort(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I16));
        }

        @ExportMessage
        static int readI32(Object obj, long offset, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return LLVMTypesGen.asInteger(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I32));
        }

        @ExportMessage
        static Object readGenericI64(Object obj, long offset, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.I64);
        }

        @ExportMessage
        static float readFloat(Object obj, long offset, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return LLVMTypesGen.asFloat(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.FLOAT));
        }

        @ExportMessage
        static double readDouble(Object obj, long offset, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return LLVMTypesGen.asDouble(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.DOUBLE));
        }

        @ExportMessage
        static LLVMPointer readPointer(Object obj, long offset, @Cached LLVMToPointerNode toPointer, @Cached.Shared(value="read") @Cached(value="createRead()", allowUncached=true) LLVMObjectAccess.LLVMObjectReadNode read) {
            return toPointer.executeWithTarget(read.executeRead(obj, offset, ForeignToLLVM.ForeignToLLVMType.POINTER));
        }
    }
}

