/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToLLVM.class)
public final class ToLLVMNodeGen
extends ToLLVM {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private ToLLVM.ReadValue convert_read_;
    @Node.Child
    private ToLLVM.ConvertValue convert_convert_;
    @Node.Child
    private ConvertTypeMismatchData convertTypeMismatch_cache;
    @Node.Child
    private ToLLVM.ReadUnknown unknownType_read_;

    private ToLLVMNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeWithType(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
        int state = this.state_;
        if (state != 0) {
            ConvertTypeMismatchData s2_;
            if ((state & 1) != 0 && arg1Value != null && arg1Value.getSize() == (long)arg2Value.getSizeInBytes()) {
                try {
                    return this.doConvert(arg0Value, arg1Value, arg2Value, this.convert_read_, this.convert_convert_);
                }
                catch (UnsupportedMessageException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_ &= 0xFFFFFFFE;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                }
            }
            if ((state & 2) != 0 && (s2_ = this.convertTypeMismatch_cache) != null && arg1Value != null) {
                return this.doConvertTypeMismatch(arg0Value, arg1Value, arg2Value, s2_.read_, s2_.convert_, s2_.readUnknown_);
            }
            if ((state & 4) != 0 && arg1Value == null) {
                return ToLLVM.doUnknownType(arg0Value, arg1Value, arg2Value, this.unknownType_read_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && arg1Value != null && arg1Value.getSize() == (long)arg2Value.getSizeInBytes()) {
                this.convert_read_ = (ToLLVM.ReadValue)super.insert((Node)ReadValueNodeGen.create());
                this.convert_convert_ = (ToLLVM.ConvertValue)super.insert((Node)ConvertValueNodeGen.create());
                this.state_ = state |= 1;
                try {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doConvert(arg0Value, arg1Value, arg2Value, this.convert_read_, this.convert_convert_);
                    return object;
                }
                catch (UnsupportedMessageException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_ &= 0xFFFFFFFE;
                    }
                    finally {
                        lock.unlock();
                    }
                    Object object = this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                    if (hasLock) {
                        lock.unlock();
                    }
                    return object;
                }
            }
            if (arg1Value != null) {
                ConvertTypeMismatchData s2_ = (ConvertTypeMismatchData)super.insert((Node)new ConvertTypeMismatchData());
                s2_.read_ = s2_.insertAccessor(ReadValueNodeGen.create());
                s2_.convert_ = s2_.insertAccessor(ConvertValueNodeGen.create());
                s2_.readUnknown_ = s2_.insertAccessor(ReadUnknownNodeGen.create());
                this.convertTypeMismatch_cache = s2_;
                this.exclude_ = exclude |= 1;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doConvertTypeMismatch(arg0Value, arg1Value, arg2Value, s2_.read_, s2_.convert_, s2_.readUnknown_);
                return object;
            }
            if (arg1Value == null) {
                this.unknownType_read_ = (ToLLVM.ReadUnknown)super.insert((Node)ReadUnknownNodeGen.create());
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Object object = ToLLVM.doUnknownType(arg0Value, arg1Value, arg2Value, this.unknownType_read_);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToLLVM create() {
        return new ToLLVMNodeGen();
    }

    public static ToLLVM getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToLLVM.ReadUnknown.class)
    static final class ReadUnknownNodeGen
    extends ToLLVM.ReadUnknown {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private ForeignToLLVM toI1_toI1_;
        @Node.Child
        private ForeignToLLVM toI8_toI8_;
        @Node.Child
        private ForeignToLLVM toI16_toI16_;
        @Node.Child
        private ForeignToLLVM toI32_toI32_;
        @Node.Child
        private ForeignToLLVM toI64_toI64_;
        @Node.Child
        private ForeignToLLVM toFloat_toFloat_;
        @Node.Child
        private ForeignToLLVM toDouble_toDouble_;
        @Node.Child
        private ForeignToLLVM toPointer_toPointer_;

        private ReadUnknownNodeGen() {
        }

        @Override
        protected Object executeWithType(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && ToLLVM.ReadUnknown.isI1(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI1(arg0Value, arg1Value, this.toI1_toI1_);
                }
                if ((state & 2) != 0 && ToLLVM.ReadUnknown.isI8(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI8(arg0Value, arg1Value, this.toI8_toI8_);
                }
                if ((state & 4) != 0 && ToLLVM.ReadUnknown.isI16(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI16(arg0Value, arg1Value, this.toI16_toI16_);
                }
                if ((state & 8) != 0 && ToLLVM.ReadUnknown.isI32(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI32(arg0Value, arg1Value, this.toI32_toI32_);
                }
                if ((state & 0x10) != 0 && ToLLVM.ReadUnknown.isI64(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI64(arg0Value, arg1Value, this.toI64_toI64_);
                }
                if ((state & 0x20) != 0 && ToLLVM.ReadUnknown.isFloat(arg1Value)) {
                    return Float.valueOf(ToLLVM.ReadUnknown.toFloat(arg0Value, arg1Value, this.toFloat_toFloat_));
                }
                if ((state & 0x40) != 0 && ToLLVM.ReadUnknown.isDouble(arg1Value)) {
                    return ToLLVM.ReadUnknown.toDouble(arg0Value, arg1Value, this.toDouble_toDouble_);
                }
                if ((state & 0x80) != 0 && ToLLVM.ReadUnknown.isPointer(arg1Value)) {
                    return ToLLVM.ReadUnknown.toPointer(arg0Value, arg1Value, this.toPointer_toPointer_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (ToLLVM.ReadUnknown.isI1(arg1Value)) {
                    this.toI1_toI1_ = (ForeignToLLVM)super.insert((Node)this.createToI1());
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = ToLLVM.ReadUnknown.toI1(arg0Value, arg1Value, this.toI1_toI1_);
                    return bl;
                }
                if (ToLLVM.ReadUnknown.isI8(arg1Value)) {
                    this.toI8_toI8_ = (ForeignToLLVM)super.insert((Node)this.createToI8());
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Byte by = ToLLVM.ReadUnknown.toI8(arg0Value, arg1Value, this.toI8_toI8_);
                    return by;
                }
                if (ToLLVM.ReadUnknown.isI16(arg1Value)) {
                    this.toI16_toI16_ = (ForeignToLLVM)super.insert((Node)this.createToI16());
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    Short s = ToLLVM.ReadUnknown.toI16(arg0Value, arg1Value, this.toI16_toI16_);
                    return s;
                }
                if (ToLLVM.ReadUnknown.isI32(arg1Value)) {
                    this.toI32_toI32_ = (ForeignToLLVM)super.insert((Node)this.createToI32());
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    Integer n = ToLLVM.ReadUnknown.toI32(arg0Value, arg1Value, this.toI32_toI32_);
                    return n;
                }
                if (ToLLVM.ReadUnknown.isI64(arg1Value)) {
                    this.toI64_toI64_ = (ForeignToLLVM)super.insert((Node)this.createToI64());
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = ToLLVM.ReadUnknown.toI64(arg0Value, arg1Value, this.toI64_toI64_);
                    return object;
                }
                if (ToLLVM.ReadUnknown.isFloat(arg1Value)) {
                    this.toFloat_toFloat_ = (ForeignToLLVM)super.insert((Node)this.createToFloat());
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Float f = Float.valueOf(ToLLVM.ReadUnknown.toFloat(arg0Value, arg1Value, this.toFloat_toFloat_));
                    return f;
                }
                if (ToLLVM.ReadUnknown.isDouble(arg1Value)) {
                    this.toDouble_toDouble_ = (ForeignToLLVM)super.insert((Node)this.createToDouble());
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    Double d = ToLLVM.ReadUnknown.toDouble(arg0Value, arg1Value, this.toDouble_toDouble_);
                    return d;
                }
                if (ToLLVM.ReadUnknown.isPointer(arg1Value)) {
                    this.toPointer_toPointer_ = (ForeignToLLVM)super.insert((Node)this.createToPointer());
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    Object object = ToLLVM.ReadUnknown.toPointer(arg0Value, arg1Value, this.toPointer_toPointer_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ToLLVM.ReadUnknown create() {
            return new ReadUnknownNodeGen();
        }

        public static ToLLVM.ReadUnknown getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ToLLVM.ReadUnknown.class)
        private static final class Uncached
        extends ToLLVM.ReadUnknown {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object executeWithType(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
                if (ToLLVM.ReadUnknown.isI1(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI1(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                if (ToLLVM.ReadUnknown.isI8(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI8(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                if (ToLLVM.ReadUnknown.isI16(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI16(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                if (ToLLVM.ReadUnknown.isI32(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI32(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                if (ToLLVM.ReadUnknown.isI64(arg1Value)) {
                    return ToLLVM.ReadUnknown.toI64(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                if (ToLLVM.ReadUnknown.isFloat(arg1Value)) {
                    return Float.valueOf(ToLLVM.ReadUnknown.toFloat(arg0Value, arg1Value, ForeignToLLVM.getUncached()));
                }
                if (ToLLVM.ReadUnknown.isDouble(arg1Value)) {
                    return ToLLVM.ReadUnknown.toDouble(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                if (ToLLVM.ReadUnknown.isPointer(arg1Value)) {
                    return ToLLVM.ReadUnknown.toPointer(arg0Value, arg1Value, ForeignToLLVM.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ToLLVM.ConvertValue.class)
    static final class ConvertValueNodeGen
    extends ToLLVM.ConvertValue {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ConvertValueNodeGen() {
        }

        @Override
        protected Object execute(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            int state = this.state_;
            if (state != 0) {
                byte arg0Value_;
                if ((state & 1) != 0 && arg0Value instanceof Boolean) {
                    arg0Value_ = ((Boolean)arg0Value).booleanValue();
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I1) {
                        return ToLLVM.ConvertValue.doI1(arg0Value_ != 0, arg1Value);
                    }
                }
                if ((state & 2) != 0 && arg0Value instanceof Byte) {
                    arg0Value_ = (Byte)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I8) {
                        return ToLLVM.ConvertValue.doI8(arg0Value_, arg1Value);
                    }
                }
                if ((state & 4) != 0 && arg0Value instanceof Short) {
                    arg0Value_ = ((Short)arg0Value).shortValue();
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I16) {
                        return ToLLVM.ConvertValue.doI16(arg0Value_, arg1Value);
                    }
                }
                if ((state & 8) != 0 && arg0Value instanceof Integer) {
                    arg0Value_ = (Integer)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I32) {
                        return ToLLVM.ConvertValue.doI32(arg0Value_, arg1Value);
                    }
                }
                if ((state & 0x10) != 0 && arg0Value instanceof Float) {
                    float arg0Value_2 = ((Float)arg0Value).floatValue();
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I32) {
                        return ToLLVM.ConvertValue.doI32(arg0Value_2, arg1Value);
                    }
                }
                if ((state & 0x20) != 0 && arg0Value instanceof Long) {
                    long arg0Value_3 = (Long)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                        return ToLLVM.ConvertValue.doI64(arg0Value_3, arg1Value);
                    }
                }
                if ((state & 0x40) != 0 && arg0Value instanceof Double) {
                    double arg0Value_4 = (Double)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                        return ToLLVM.ConvertValue.doI64(arg0Value_4, arg1Value);
                    }
                }
                if ((state & 0x80) != 0 && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_5 = LLVMTypes.asPointer(arg0Value);
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                        return ToLLVM.ConvertValue.doI64(arg0Value_5, arg1Value);
                    }
                }
                if ((state & 0x100) != 0 && arg0Value instanceof Float) {
                    float arg0Value_6 = ((Float)arg0Value).floatValue();
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.FLOAT) {
                        return Float.valueOf(ToLLVM.ConvertValue.doFloat(arg0Value_6, arg1Value));
                    }
                }
                if ((state & 0x200) != 0 && arg0Value instanceof Integer) {
                    int arg0Value_7 = (Integer)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.FLOAT) {
                        return Float.valueOf(ToLLVM.ConvertValue.doFloat(arg0Value_7, arg1Value));
                    }
                }
                if ((state & 0x400) != 0 && arg0Value instanceof Double) {
                    double arg0Value_8 = (Double)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.DOUBLE) {
                        return ToLLVM.ConvertValue.doDouble(arg0Value_8, arg1Value);
                    }
                }
                if ((state & 0x800) != 0 && arg0Value instanceof Long) {
                    long arg0Value_9 = (Long)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.DOUBLE) {
                        return ToLLVM.ConvertValue.doDouble(arg0Value_9, arg1Value);
                    }
                }
                if ((state & 0x1000) != 0 && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_10 = LLVMTypes.asPointer(arg0Value);
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.POINTER) {
                        return ToLLVM.ConvertValue.doPointer(arg0Value_10, arg1Value);
                    }
                }
                if ((state & 0x2000) != 0 && arg0Value instanceof Long) {
                    long arg0Value_11 = (Long)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.POINTER) {
                        return ToLLVM.ConvertValue.doPointer(arg0Value_11, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
            int state = this.state_;
            if (arg0Value instanceof Boolean) {
                boolean bl = (Boolean)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I1) {
                    this.state_ = state |= 1;
                    return ToLLVM.ConvertValue.doI1(bl, arg1Value);
                }
            }
            if (arg0Value instanceof Byte) {
                byte by = (Byte)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I8) {
                    this.state_ = state |= 2;
                    return ToLLVM.ConvertValue.doI8(by, arg1Value);
                }
            }
            if (arg0Value instanceof Short) {
                short s = (Short)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I16) {
                    this.state_ = state |= 4;
                    return ToLLVM.ConvertValue.doI16(s, arg1Value);
                }
            }
            if (arg0Value instanceof Integer) {
                int n = (Integer)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I32) {
                    this.state_ = state |= 8;
                    return ToLLVM.ConvertValue.doI32(n, arg1Value);
                }
            }
            if (arg0Value instanceof Float) {
                float f = ((Float)arg0Value).floatValue();
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I32) {
                    this.state_ = state |= 0x10;
                    return ToLLVM.ConvertValue.doI32(f, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long l = (Long)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                    this.state_ = state |= 0x20;
                    return ToLLVM.ConvertValue.doI64(l, arg1Value);
                }
            }
            if (arg0Value instanceof Double) {
                double d = (Double)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                    this.state_ = state |= 0x40;
                    return ToLLVM.ConvertValue.doI64(d, arg1Value);
                }
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg0Value);
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                    this.state_ = state |= 0x80;
                    return ToLLVM.ConvertValue.doI64(lLVMPointer, arg1Value);
                }
            }
            if (arg0Value instanceof Float) {
                float f = ((Float)arg0Value).floatValue();
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.FLOAT) {
                    this.state_ = state |= 0x100;
                    return Float.valueOf(ToLLVM.ConvertValue.doFloat(f, arg1Value));
                }
            }
            if (arg0Value instanceof Integer) {
                int n = (Integer)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.FLOAT) {
                    this.state_ = state |= 0x200;
                    return Float.valueOf(ToLLVM.ConvertValue.doFloat(n, arg1Value));
                }
            }
            if (arg0Value instanceof Double) {
                double d = (Double)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.DOUBLE) {
                    this.state_ = state |= 0x400;
                    return ToLLVM.ConvertValue.doDouble(d, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long l = (Long)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.DOUBLE) {
                    this.state_ = state |= 0x800;
                    return ToLLVM.ConvertValue.doDouble(l, arg1Value);
                }
            }
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg0Value);
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.POINTER) {
                    this.state_ = state |= 0x1000;
                    return ToLLVM.ConvertValue.doPointer(lLVMPointer, arg1Value);
                }
            }
            if (arg0Value instanceof Long) {
                long l = (Long)arg0Value;
                if (arg1Value == ForeignToLLVM.ForeignToLLVMType.POINTER) {
                    this.state_ = state |= 0x2000;
                    return ToLLVM.ConvertValue.doPointer(l, arg1Value);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ToLLVM.ConvertValue create() {
            return new ConvertValueNodeGen();
        }

        public static ToLLVM.ConvertValue getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ToLLVM.ConvertValue.class)
        private static final class Uncached
        extends ToLLVM.ConvertValue {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object execute(Object arg0Value, ForeignToLLVM.ForeignToLLVMType arg1Value) {
                if (arg0Value instanceof Boolean) {
                    boolean bl = (Boolean)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I1) {
                        return ToLLVM.ConvertValue.doI1(bl, arg1Value);
                    }
                }
                if (arg0Value instanceof Byte) {
                    byte by = (Byte)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I8) {
                        return ToLLVM.ConvertValue.doI8(by, arg1Value);
                    }
                }
                if (arg0Value instanceof Short) {
                    short s = (Short)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I16) {
                        return ToLLVM.ConvertValue.doI16(s, arg1Value);
                    }
                }
                if (arg0Value instanceof Integer) {
                    int n = (Integer)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I32) {
                        return ToLLVM.ConvertValue.doI32(n, arg1Value);
                    }
                }
                if (arg0Value instanceof Float) {
                    float f = ((Float)arg0Value).floatValue();
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I32) {
                        return ToLLVM.ConvertValue.doI32(f, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long l = (Long)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                        return ToLLVM.ConvertValue.doI64(l, arg1Value);
                    }
                }
                if (arg0Value instanceof Double) {
                    double d = (Double)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                        return ToLLVM.ConvertValue.doI64(d, arg1Value);
                    }
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg0Value);
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.I64) {
                        return ToLLVM.ConvertValue.doI64(lLVMPointer, arg1Value);
                    }
                }
                if (arg0Value instanceof Float) {
                    float f = ((Float)arg0Value).floatValue();
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.FLOAT) {
                        return Float.valueOf(ToLLVM.ConvertValue.doFloat(f, arg1Value));
                    }
                }
                if (arg0Value instanceof Integer) {
                    int n = (Integer)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.FLOAT) {
                        return Float.valueOf(ToLLVM.ConvertValue.doFloat(n, arg1Value));
                    }
                }
                if (arg0Value instanceof Double) {
                    double d = (Double)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.DOUBLE) {
                        return ToLLVM.ConvertValue.doDouble(d, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long l = (Long)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.DOUBLE) {
                        return ToLLVM.ConvertValue.doDouble(l, arg1Value);
                    }
                }
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer lLVMPointer = LLVMTypes.asPointer(arg0Value);
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.POINTER) {
                        return ToLLVM.ConvertValue.doPointer(lLVMPointer, arg1Value);
                    }
                }
                if (arg0Value instanceof Long) {
                    long l = (Long)arg0Value;
                    if (arg1Value == ForeignToLLVM.ForeignToLLVMType.POINTER) {
                        return ToLLVM.ConvertValue.doPointer(l, arg1Value);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ToLLVM.ReadValue.class)
    static final class ReadValueNodeGen
    extends ToLLVM.ReadValue {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private I10Data i10_cache;
        @Node.Child
        private I80Data i80_cache;
        @Node.Child
        private I160Data i160_cache;
        @Node.Child
        private I320Data i320_cache;
        @Node.Child
        private I640Data i640_cache;
        @Node.Child
        private Float0Data float0_cache;
        @Node.Child
        private Double0Data double0_cache;
        @Node.Child
        private ToLLVM.WrapPointer pointer_wrap_;

        private ReadValueNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected Object execute(Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    I10Data s1_ = this.i10_cache;
                    while (s1_ != null) {
                        if (s1_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I1) {
                            return ToLLVM.ReadValue.doI1(arg0Value, arg1Value, s1_.interop_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.I1) {
                    return this.i11Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 4) != 0) {
                    I80Data s3_ = this.i80_cache;
                    while (s3_ != null) {
                        if (s3_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I8) {
                            return ToLLVM.ReadValue.doI8(arg0Value, arg1Value, s3_.interop_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.I8) {
                    return this.i81Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 0x10) != 0) {
                    I160Data s5_ = this.i160_cache;
                    while (s5_ != null) {
                        if (s5_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I16) {
                            return ToLLVM.ReadValue.doI16(arg0Value, arg1Value, s5_.interop_);
                        }
                        s5_ = s5_.next_;
                    }
                }
                if ((state & 0x20) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.I16) {
                    return this.i161Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 0x40) != 0) {
                    I320Data s7_ = this.i320_cache;
                    while (s7_ != null) {
                        if (s7_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I32) {
                            return ToLLVM.ReadValue.doI32(arg0Value, arg1Value, s7_.interop_);
                        }
                        s7_ = s7_.next_;
                    }
                }
                if ((state & 0x80) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.I32) {
                    return this.i321Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 0x100) != 0) {
                    I640Data s9_ = this.i640_cache;
                    while (s9_ != null) {
                        if (s9_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I64) {
                            return ToLLVM.ReadValue.doI64(arg0Value, arg1Value, s9_.interop_);
                        }
                        s9_ = s9_.next_;
                    }
                }
                if ((state & 0x200) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.I64) {
                    return this.i641Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 0x400) != 0) {
                    Float0Data s11_ = this.float0_cache;
                    while (s11_ != null) {
                        if (s11_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.FLOAT) {
                            return Float.valueOf(ToLLVM.ReadValue.doFloat(arg0Value, arg1Value, s11_.interop_));
                        }
                        s11_ = s11_.next_;
                    }
                }
                if ((state & 0x800) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.FLOAT) {
                    return this.float1Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 0x1000) != 0) {
                    Double0Data s13_ = this.double0_cache;
                    while (s13_ != null) {
                        if (s13_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.DOUBLE) {
                            return ToLLVM.ReadValue.doDouble(arg0Value, arg1Value, s13_.interop_);
                        }
                        s13_ = s13_.next_;
                    }
                }
                if ((state & 0x2000) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.DOUBLE) {
                    return this.double1Boundary(state, arg0Value, arg1Value);
                }
                if ((state & 0x4000) != 0 && arg1Value.getKind() == LLVMInteropType.ValueKind.POINTER) {
                    return ToLLVM.ReadValue.doPointer(arg0Value, arg1Value, this.pointer_wrap_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i11Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Boolean bl = ToLLVM.ReadValue.doI1(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                return bl;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i81Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Byte by = ToLLVM.ReadValue.doI8(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                return by;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i161Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Short s = ToLLVM.ReadValue.doI16(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                return s;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i321Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Integer n = ToLLVM.ReadValue.doI32(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                return n;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object i641Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Long l = ToLLVM.ReadValue.doI64(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                return l;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object float1Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Float f = Float.valueOf(ToLLVM.ReadValue.doFloat(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)));
                return f;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object double1Boundary(int state, Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Double d = ToLLVM.ReadValue.doDouble(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                return d;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                Object s11_;
                Object s9_;
                Object s7_;
                Object s5_;
                Object s3_;
                Object s1_;
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    s1_ = this.i10_cache;
                    if ((state & 1) != 0) {
                        while (!(s1_ == null || s1_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I1)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.I1 && count1_ < 3) {
                        s1_ = (I10Data)super.insert((Node)new I10Data(this.i10_cache));
                        s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.i10_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Boolean bl = ToLLVM.ReadValue.doI1(arg0Value, arg1Value, s1_.interop_);
                        return bl;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.I1) {
                        this.exclude_ = exclude |= 1;
                        this.i10_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        s1_ = ToLLVM.ReadValue.doI1(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return s1_;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 2) == 0) {
                    int count3_ = 0;
                    s3_ = this.i80_cache;
                    if ((state & 4) != 0) {
                        while (!(s3_ == null || s3_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I8)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.I8 && count3_ < 3) {
                        s3_ = (I80Data)super.insert((Node)new I80Data(this.i80_cache));
                        s3_.interop_ = s3_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.i80_cache = s3_;
                        this.state_ = state |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Byte by = ToLLVM.ReadValue.doI8(arg0Value, arg1Value, s3_.interop_);
                        return by;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.I8) {
                        this.exclude_ = exclude |= 2;
                        this.i80_cache = null;
                        state &= 0xFFFFFFFB;
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        s3_ = ToLLVM.ReadValue.doI8(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return s3_;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 4) == 0) {
                    int count5_ = 0;
                    s5_ = this.i160_cache;
                    if ((state & 0x10) != 0) {
                        while (!(s5_ == null || s5_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I16)) {
                            s5_ = s5_.next_;
                            ++count5_;
                        }
                    }
                    if (s5_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.I16 && count5_ < 3) {
                        s5_ = (I160Data)super.insert((Node)new I160Data(this.i160_cache));
                        s5_.interop_ = s5_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.i160_cache = s5_;
                        this.state_ = state |= 0x10;
                    }
                    if (s5_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Short s = ToLLVM.ReadValue.doI16(arg0Value, arg1Value, s5_.interop_);
                        return s;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.I16) {
                        this.exclude_ = exclude |= 4;
                        this.i160_cache = null;
                        state &= 0xFFFFFFEF;
                        this.state_ = state |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        s5_ = ToLLVM.ReadValue.doI16(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return s5_;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 8) == 0) {
                    int count7_ = 0;
                    s7_ = this.i320_cache;
                    if ((state & 0x40) != 0) {
                        while (!(s7_ == null || s7_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I32)) {
                            s7_ = s7_.next_;
                            ++count7_;
                        }
                    }
                    if (s7_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.I32 && count7_ < 3) {
                        s7_ = (I320Data)super.insert((Node)new I320Data(this.i320_cache));
                        s7_.interop_ = s7_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.i320_cache = s7_;
                        this.state_ = state |= 0x40;
                    }
                    if (s7_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Integer n = ToLLVM.ReadValue.doI32(arg0Value, arg1Value, s7_.interop_);
                        return n;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.I32) {
                        this.exclude_ = exclude |= 8;
                        this.i320_cache = null;
                        state &= 0xFFFFFFBF;
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        s7_ = ToLLVM.ReadValue.doI32(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return s7_;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 0x10) == 0) {
                    int count9_ = 0;
                    s9_ = this.i640_cache;
                    if ((state & 0x100) != 0) {
                        while (!(s9_ == null || s9_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.I64)) {
                            s9_ = s9_.next_;
                            ++count9_;
                        }
                    }
                    if (s9_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.I64 && count9_ < 3) {
                        s9_ = (I640Data)super.insert((Node)new I640Data(this.i640_cache));
                        s9_.interop_ = s9_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.i640_cache = s9_;
                        this.state_ = state |= 0x100;
                    }
                    if (s9_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Long l = ToLLVM.ReadValue.doI64(arg0Value, arg1Value, s9_.interop_);
                        return l;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.I64) {
                        this.exclude_ = exclude |= 0x10;
                        this.i640_cache = null;
                        state &= 0xFFFFFEFF;
                        this.state_ = state |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        s9_ = ToLLVM.ReadValue.doI64(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return s9_;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 0x20) == 0) {
                    int count11_ = 0;
                    s11_ = this.float0_cache;
                    if ((state & 0x400) != 0) {
                        while (!(s11_ == null || s11_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.FLOAT)) {
                            s11_ = s11_.next_;
                            ++count11_;
                        }
                    }
                    if (s11_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.FLOAT && count11_ < 3) {
                        s11_ = (Float0Data)super.insert((Node)new Float0Data(this.float0_cache));
                        s11_.interop_ = s11_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.float0_cache = s11_;
                        this.state_ = state |= 0x400;
                    }
                    if (s11_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Float f = Float.valueOf(ToLLVM.ReadValue.doFloat(arg0Value, arg1Value, s11_.interop_));
                        return f;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.FLOAT) {
                        this.exclude_ = exclude |= 0x20;
                        this.float0_cache = null;
                        state &= 0xFFFFFBFF;
                        this.state_ = state |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        s11_ = Float.valueOf(ToLLVM.ReadValue.doFloat(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)));
                        return s11_;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if ((exclude & 0x40) == 0) {
                    int count13_ = 0;
                    Double0Data s13_ = this.double0_cache;
                    if ((state & 0x1000) != 0) {
                        while (!(s13_ == null || s13_.interop_.accepts(arg0Value) && arg1Value.getKind() == LLVMInteropType.ValueKind.DOUBLE)) {
                            s13_ = s13_.next_;
                            ++count13_;
                        }
                    }
                    if (s13_ == null && arg1Value.getKind() == LLVMInteropType.ValueKind.DOUBLE && count13_ < 3) {
                        s13_ = (Double0Data)super.insert((Node)new Double0Data(this.double0_cache));
                        s13_.interop_ = s13_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value));
                        this.double0_cache = s13_;
                        this.state_ = state |= 0x1000;
                    }
                    if (s13_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Double d = ToLLVM.ReadValue.doDouble(arg0Value, arg1Value, s13_.interop_);
                        return d;
                    }
                }
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (arg1Value.getKind() == LLVMInteropType.ValueKind.DOUBLE) {
                        this.exclude_ = exclude |= 0x40;
                        this.double0_cache = null;
                        state &= 0xFFFFEFFF;
                        this.state_ = state |= 0x2000;
                        lock.unlock();
                        hasLock = false;
                        Double d = ToLLVM.ReadValue.doDouble(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return d;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.POINTER) {
                    this.pointer_wrap_ = (ToLLVM.WrapPointer)super.insert((Node)WrapPointerNodeGen.create());
                    this.state_ = state |= 0x4000;
                    lock.unlock();
                    hasLock = false;
                    LLVMPointer lLVMPointer = ToLLVM.ReadValue.doPointer(arg0Value, arg1Value, this.pointer_wrap_);
                    return lLVMPointer;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                I10Data s1_ = this.i10_cache;
                I80Data s3_ = this.i80_cache;
                I160Data s5_ = this.i160_cache;
                I320Data s7_ = this.i320_cache;
                I640Data s9_ = this.i640_cache;
                Float0Data s11_ = this.float0_cache;
                Double0Data s13_ = this.double0_cache;
                if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null || s5_ != null && s5_.next_ != null || s7_ != null && s7_.next_ != null || s9_ != null && s9_.next_ != null || s11_ != null && s11_.next_ != null || s13_ != null && s13_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ToLLVM.ReadValue create() {
            return new ReadValueNodeGen();
        }

        public static ToLLVM.ReadValue getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class Uncached
        extends ToLLVM.ReadValue {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object execute(Object arg0Value, LLVMInteropType.Value arg1Value) throws UnsupportedMessageException {
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.I1) {
                    return ToLLVM.ReadValue.doI1(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.I8) {
                    return ToLLVM.ReadValue.doI8(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.I16) {
                    return ToLLVM.ReadValue.doI16(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.I32) {
                    return ToLLVM.ReadValue.doI32(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.I64) {
                    return ToLLVM.ReadValue.doI64(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.FLOAT) {
                    return Float.valueOf(ToLLVM.ReadValue.doFloat(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.DOUBLE) {
                    return ToLLVM.ReadValue.doDouble(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                }
                if (arg1Value.getKind() == LLVMInteropType.ValueKind.POINTER) {
                    return ToLLVM.ReadValue.doPointer(arg0Value, arg1Value, WrapPointerNodeGen.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class Double0Data
        extends Node {
            @Node.Child
            Double0Data next_;
            @Node.Child
            InteropLibrary interop_;

            Double0Data(Double0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class Float0Data
        extends Node {
            @Node.Child
            Float0Data next_;
            @Node.Child
            InteropLibrary interop_;

            Float0Data(Float0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class I640Data
        extends Node {
            @Node.Child
            I640Data next_;
            @Node.Child
            InteropLibrary interop_;

            I640Data(I640Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class I320Data
        extends Node {
            @Node.Child
            I320Data next_;
            @Node.Child
            InteropLibrary interop_;

            I320Data(I320Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class I160Data
        extends Node {
            @Node.Child
            I160Data next_;
            @Node.Child
            InteropLibrary interop_;

            I160Data(I160Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class I80Data
        extends Node {
            @Node.Child
            I80Data next_;
            @Node.Child
            InteropLibrary interop_;

            I80Data(I80Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=ToLLVM.ReadValue.class)
        private static final class I10Data
        extends Node {
            @Node.Child
            I10Data next_;
            @Node.Child
            InteropLibrary interop_;

            I10Data(I10Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=ToLLVM.WrapPointer.class)
    static final class WrapPointerNodeGen
    extends ToLLVM.WrapPointer {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_;

        private WrapPointerNodeGen() {
        }

        @Override
        protected LLVMPointer execute(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0 && LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    return this.doPointer(arg0Value_, arg1Value);
                }
                if ((state & 2) != 0 && WrapPointerNodeGen.fallbackGuard_(state, arg0Value, arg1Value)) {
                    return this.doOther(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private LLVMPointer executeAndSpecialize(Object arg0Value, LLVMInteropType.Structured arg1Value) {
            int state = this.state_;
            if (LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                this.state_ = state |= 1;
                return this.doPointer(arg0Value_, arg1Value);
            }
            this.state_ = state |= 2;
            return this.doOther(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        private static boolean fallbackGuard_(int state, Object arg0Value, LLVMInteropType.Structured arg1Value) {
            return (state & 1) != 0 || !LLVMTypes.isPointer(arg0Value);
        }

        public static ToLLVM.WrapPointer create() {
            return new WrapPointerNodeGen();
        }

        public static ToLLVM.WrapPointer getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=ToLLVM.WrapPointer.class)
        private static final class Uncached
        extends ToLLVM.WrapPointer {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected LLVMPointer execute(Object arg0Value, LLVMInteropType.Structured arg1Value) {
                if (LLVMTypes.isPointer(arg0Value)) {
                    LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                    return this.doPointer(arg0Value_, arg1Value);
                }
                return this.doOther(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=ToLLVM.class)
    private static final class Uncached
    extends ToLLVM {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object executeWithType(Object arg0Value, LLVMInteropType.Value arg1Value, ForeignToLLVM.ForeignToLLVMType arg2Value) {
            if (arg1Value != null) {
                return this.doConvertTypeMismatch(arg0Value, arg1Value, arg2Value, ReadValueNodeGen.getUncached(), ConvertValueNodeGen.getUncached(), ReadUnknownNodeGen.getUncached());
            }
            if (arg1Value == null) {
                return ToLLVM.doUnknownType(arg0Value, arg1Value, arg2Value, ReadUnknownNodeGen.getUncached());
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ToLLVM.class)
    private static final class ConvertTypeMismatchData
    extends Node {
        @Node.Child
        ToLLVM.ReadValue read_;
        @Node.Child
        ToLLVM.ConvertValue convert_;
        @Node.Child
        ToLLVM.ReadUnknown readUnknown_;

        ConvertTypeMismatchData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

