/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObjectFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropReadNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropWriteNode;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMObjectAccess;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import com.oracle.truffle.llvm.spi.ReferenceLibrary;

@CompilerDirectives.ValueType
@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMManagedReadLibrary.class), @ExportLibrary(value=LLVMManagedWriteLibrary.class), @ExportLibrary(value=ReferenceLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class)})
public final class LLVMTypedForeignObject
implements LLVMObjectAccess,
LLVMInternalTruffleObject {
    final Object foreign;
    private final LLVMInteropType.Structured type;

    public static LLVMTypedForeignObject create(Object foreign, LLVMInteropType.Structured type) {
        return new LLVMTypedForeignObject(foreign, type);
    }

    public static LLVMTypedForeignObject createUnknown(Object foreign) {
        return new LLVMTypedForeignObject(foreign, null);
    }

    private LLVMTypedForeignObject(Object foreign, LLVMInteropType.Structured type) {
        this.foreign = foreign;
        this.type = type;
    }

    public Object getForeign() {
        return this.foreign;
    }

    public LLVMInteropType.Structured getType() {
        return this.type;
    }

    @Override
    public LLVMObjectAccess.LLVMObjectReadNode createReadNode() {
        return new ForeignReadNode();
    }

    @Override
    public LLVMObjectAccess.LLVMObjectWriteNode createWriteNode() {
        return new ForeignWriteNode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LLVMTypedForeignObject) {
            LLVMTypedForeignObject other = (LLVMTypedForeignObject)obj;
            return this.foreign.equals(other.foreign);
        }
        return false;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
    boolean isAccessible() {
        return true;
    }

    @ExportMessage
    byte readI8(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return (Byte)read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.I8);
    }

    @ExportMessage
    short readI16(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return (Short)read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.I16);
    }

    @ExportMessage
    int readI32(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return (Integer)read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.I32);
    }

    @ExportMessage
    Object readGenericI64(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.I64);
    }

    @ExportMessage
    float readFloat(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return ((Float)read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.FLOAT)).floatValue();
    }

    @ExportMessage
    double readDouble(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return (Double)read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.DOUBLE);
    }

    @ExportMessage
    LLVMPointer readPointer(long offset, @Cached.Shared(value="read") @Cached LLVMInteropReadNode read, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        return LLVMPointer.cast(read.execute(getType.execute(this), this.getForeign(), offset, ForeignToLLVM.ForeignToLLVMType.POINTER));
    }

    @ExportMessage
    void writeI8(long offset, byte value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, value, ForeignToLLVM.ForeignToLLVMType.I8);
    }

    @ExportMessage
    void writeI16(long offset, short value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, value, ForeignToLLVM.ForeignToLLVMType.I16);
    }

    @ExportMessage
    void writeI32(long offset, int value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, value, ForeignToLLVM.ForeignToLLVMType.I32);
    }

    @ExportMessage
    void writeGenericI64(long offset, Object value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, value, ForeignToLLVM.ForeignToLLVMType.I64);
    }

    @ExportMessage
    void writeFloat(long offset, float value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, Float.valueOf(value), ForeignToLLVM.ForeignToLLVMType.FLOAT);
    }

    @ExportMessage
    void writeDouble(long offset, double value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, value, ForeignToLLVM.ForeignToLLVMType.DOUBLE);
    }

    @ExportMessage
    void writePointer(long offset, LLVMPointer value, @Cached.Shared(value="write") @Cached LLVMInteropWriteNode write, @Cached.Shared(value="getType") @Cached ForeignGetTypeNode getType) {
        write.execute(getType.execute(this), this.getForeign(), offset, value, ForeignToLLVM.ForeignToLLVMType.POINTER);
    }

    @ExportMessage
    boolean isNull(@CachedLibrary(value="this.foreign") InteropLibrary interop) {
        return interop.isNull(this.getForeign());
    }

    @ExportMessage
    boolean isPointer(@CachedLibrary(value="this.foreign") InteropLibrary interop) {
        return interop.isPointer(this.getForeign());
    }

    @ExportMessage
    long asPointer(@CachedLibrary(value="this.foreign") InteropLibrary interop) throws UnsupportedMessageException {
        return interop.asPointer(this.getForeign());
    }

    @ExportMessage
    void toNative(@CachedLibrary(value="this.foreign") InteropLibrary interop) {
        interop.toNative(this.getForeign());
    }

    @ExportMessage
    static class IsSame {
        IsSame() {
        }

        @Specialization
        static boolean doTyped(LLVMTypedForeignObject receiver, LLVMTypedForeignObject other, @Cached CompareForeignNode compare) {
            return compare.execute(receiver.foreign, other.foreign);
        }

        @Fallback
        static boolean doGeneric(LLVMTypedForeignObject receiver, Object other) {
            return false;
        }
    }

    @GenerateUncached
    static abstract class CompareForeignNode
    extends LLVMNode {
        CompareForeignNode() {
        }

        protected abstract boolean execute(Object var1, Object var2);

        @Specialization(guards={"ctx.getEnv().isHostObject(a)", "ctx.getEnv().isHostObject(b)"})
        static boolean doHostObjects(Object a, Object b, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx) {
            TruffleLanguage.Env env = ctx.getEnv();
            return env.asHostObject(a) == env.asHostObject(b);
        }

        @Specialization(limit="3", guards={"!ctx.getEnv().isHostObject(a) || !ctx.getEnv().isHostObject(b)"})
        static boolean doOther(Object a, Object b, @CachedContext(value=LLVMLanguage.class) LLVMContext ctx, @CachedLibrary(value="a") ReferenceLibrary lib) {
            return lib.isSame(a, b);
        }
    }

    static class ForeignWriteNode
    extends LLVMNode
    implements LLVMObjectAccess.LLVMObjectWriteNode {
        @Node.Child
        LLVMInteropWriteNode write = LLVMInteropWriteNode.create();
        @Node.Child
        ForeignGetTypeNode getType = LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create();

        ForeignWriteNode() {
        }

        @Override
        public void executeWrite(Object obj, long offset, Object value, ForeignToLLVM.ForeignToLLVMType writeType) {
            LLVMTypedForeignObject object = (LLVMTypedForeignObject)obj;
            this.write.execute(this.getType.execute(object), object.getForeign(), offset, value, writeType);
        }

        @Override
        public boolean canAccess(Object obj) {
            return obj instanceof LLVMTypedForeignObject;
        }
    }

    static class ForeignReadNode
    extends LLVMNode
    implements LLVMObjectAccess.LLVMObjectReadNode {
        @Node.Child
        LLVMInteropReadNode read = LLVMInteropReadNode.create();
        @Node.Child
        ForeignGetTypeNode getType = LLVMTypedForeignObjectFactory.ForeignGetTypeNodeGen.create();

        ForeignReadNode() {
        }

        @Override
        public Object executeRead(Object obj, long offset, ForeignToLLVM.ForeignToLLVMType type) {
            LLVMTypedForeignObject object = (LLVMTypedForeignObject)obj;
            return this.read.execute(this.getType.execute(object), object.getForeign(), offset, type);
        }

        @Override
        public boolean canAccess(Object obj) {
            return obj instanceof LLVMTypedForeignObject;
        }
    }

    @ExportMessage
    static class GetNativeType {
        GetNativeType() {
        }

        @Specialization(guards={"typeLibrary.hasNativeType(object.foreign)"})
        static Object getType(LLVMTypedForeignObject object, @CachedLibrary(value="object.foreign") NativeTypeLibrary typeLibrary) {
            return typeLibrary.getNativeType(object.foreign);
        }

        @Specialization(limit="3", guards={"!typeLibrary.hasNativeType(object.getForeign())"})
        static LLVMInteropType.Structured doFallback(LLVMTypedForeignObject object, @CachedLibrary(value="object.getForeign()") NativeTypeLibrary typeLibrary) {
            return object.getType();
        }
    }

    @GenerateUncached
    public static abstract class ForeignGetTypeNode
    extends LLVMNode {
        public abstract LLVMInteropType.Structured execute(LLVMTypedForeignObject var1);

        @Specialization(limit="3")
        public LLVMInteropType.Structured getType(LLVMTypedForeignObject object, @CachedLibrary(value="object") NativeTypeLibrary typeLibrary) {
            Object type = typeLibrary.getNativeType((Object)object);
            if (type == null || type instanceof LLVMInteropType.Structured) {
                return (LLVMInteropType.Structured)type;
            }
            CompilerDirectives.transferToInterpreter();
            throw new LLVMPolyglotException((Node)this, "Invalid type %s returned from foreign object.", type);
        }
    }
}

