/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.value;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

public abstract class LLVMDebugManagedValue
extends LLVMDebuggerValue {
    final Object llvmType;

    private LLVMDebugManagedValue(Object llvmType) {
        this.llvmType = llvmType;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getMetaObject() {
        return this.llvmType != null ? String.valueOf(this.llvmType) : "";
    }

    public static LLVMDebugManagedValue create(Object llvmType, Object value) {
        if (LLVMManagedPointer.isInstance(value)) {
            return new Pointer(llvmType, LLVMManagedPointer.cast(value));
        }
        if (value instanceof LLVMVector) {
            LLVMVector vector = (LLVMVector)value;
            if (vector.getLength() <= 0) {
                return new GenericVector(llvmType, NO_KEYS, String.valueOf(vector.getElementType()));
            }
            String[] elements = new String[vector.getLength()];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = String.valueOf(vector.getElement(i));
            }
            return new GenericVector(llvmType, elements, String.valueOf(vector.getElementType()));
        }
        return new Generic(llvmType, value);
    }

    private static final class Generic
    extends LLVMDebugManagedValue {
        private static final String[] INTEROP_KEYS = new String[]{"<value>"};
        private final Object value;

        private Generic(Object llvmType, Object value) {
            super(llvmType);
            this.value = value;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        protected int getElementCountForDebugger() {
            return this.getKeysForDebugger().length;
        }

        @Override
        protected String[] getKeysForDebugger() {
            return this.value instanceof TruffleObject ? INTEROP_KEYS : NO_KEYS;
        }

        @Override
        protected Object getElementForDebugger(String key) {
            assert (INTEROP_KEYS[0].equals(key));
            return this.value;
        }
    }

    private static final class GenericVector
    extends LLVMDebugManagedValue {
        private final String elementType;
        private final String[] vector;

        private GenericVector(Object llvmType, String[] vector, String elementType) {
            super(llvmType);
            this.elementType = elementType;
            this.vector = vector;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            if (this.llvmType instanceof VectorType && ((VectorType)this.llvmType).getNumberOfElements() != 0 && this.vector.length == 0) {
                return "(optimized away)";
            }
            return "< " + this.vector.length + " x " + this.elementType + " >";
        }

        @Override
        protected int getElementCountForDebugger() {
            return this.vector.length;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected String[] getKeysForDebugger() {
            if (this.vector.length <= 0) {
                return NO_KEYS;
            }
            String[] keys = new String[this.vector.length];
            for (int i = 0; i < this.vector.length; ++i) {
                keys[i] = String.format("[%d]", i);
            }
            return keys;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object getElementForDebugger(String key) {
            int i;
            try {
                i = Integer.parseInt(key.substring(1, key.length() - 1));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Vector has no member named " + key);
            }
            if (i < this.vector.length) {
                return new Generic(this.elementType, this.vector[i]);
            }
            throw new IllegalArgumentException("Cannot access index " + i + " in vector of length " + this.vector.length);
        }
    }

    private static final class Pointer
    extends LLVMDebugManagedValue {
        private static final String VALUE = "<managed pointer>";
        private static final String[] DEFAULT_KEYS = new String[]{"<target>"};
        private final LLVMManagedPointer pointer;

        private Pointer(Object llvmType, LLVMManagedPointer pointer) {
            super(llvmType);
            this.pointer = pointer;
        }

        public String toString() {
            return VALUE;
        }

        @CompilerDirectives.TruffleBoundary
        private String[] getTargetKeys() {
            if (this.pointer.getOffset() == 0L) {
                return DEFAULT_KEYS;
            }
            return new String[]{"<target (offset " + this.pointer.getOffset() + " ignored)>"};
        }

        @Override
        protected int getElementCountForDebugger() {
            return this.getTargetKeys().length;
        }

        @Override
        protected String[] getKeysForDebugger() {
            return this.getTargetKeys();
        }

        @Override
        protected Object getElementForDebugger(String key) {
            assert (this.getTargetKeys()[0].equals(key));
            return this.pointer.getObject();
        }
    }
}

