/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.IndexedTypeBounds;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.function.Supplier;

public final class LLVMSourceArrayLikeType
extends LLVMSourceType {
    @CompilerDirectives.CompilationFinal
    private LLVMSourceType baseType;
    @CompilerDirectives.CompilationFinal
    private long length;

    public LLVMSourceArrayLikeType(long size, long align, long offset, LLVMSourceLocation location) {
        this(LLVMSourceType.UNKNOWN::getName, size, align, offset, LLVMSourceType.UNKNOWN, 1L, location);
    }

    private LLVMSourceArrayLikeType(Supplier<String> name, long size, long align, long offset, LLVMSourceType baseType, long length, LLVMSourceLocation location) {
        super(size, align, offset, location);
        this.setName(name);
        this.baseType = baseType;
        this.length = length;
    }

    public LLVMSourceType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(LLVMSourceType baseType) {
        CompilerAsserts.neverPartOfCompilation();
        this.baseType = baseType;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        CompilerAsserts.neverPartOfCompilation();
        this.length = length;
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return new LLVMSourceArrayLikeType(this::getName, this.getSize(), this.getAlign(), newOffset, this.baseType, this.length, this.getLocation());
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public int getElementCount() {
        return (int)this.getLength();
    }

    @Override
    public String getElementName(long i) {
        if (0L <= i && i < this.getLength()) {
            return IndexedTypeBounds.toKey(i);
        }
        return null;
    }

    @Override
    public LLVMSourceType getElementType(long i) {
        if (0L <= i && i < this.getLength()) {
            return this.baseType.getOffset(i * this.baseType.getSize());
        }
        return null;
    }

    @Override
    public LLVMSourceType getElementType(String key) {
        return this.getElementType(IndexedTypeBounds.toIndex(key));
    }

    @Override
    public LLVMSourceLocation getElementDeclaration(long i) {
        return this.getLocation();
    }

    @Override
    public LLVMSourceLocation getElementDeclaration(String name) {
        return this.getLocation();
    }
}

