/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.scope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.Objects;

public abstract class LLVMSourceSymbol {
    private final String name;
    private final LLVMSourceLocation location;
    private final LLVMSourceType type;

    public static LLVMSourceSymbol create(String name, LLVMSourceLocation location, LLVMSourceType type, boolean isStatic) {
        if (isStatic) {
            return new Static(name, location, type);
        }
        return new Dynamic(name, location, type);
    }

    private LLVMSourceSymbol(String name, LLVMSourceLocation location, LLVMSourceType type) {
        this.name = name;
        this.location = location;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public LLVMSourceLocation getLocation() {
        return this.location;
    }

    public LLVMSourceType getType() {
        return this.type;
    }

    public abstract boolean isStatic();

    public String toString() {
        return this.name;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLVMSourceSymbol symbol = (LLVMSourceSymbol)o;
        if (!this.name.equals(symbol.name)) {
            return false;
        }
        return Objects.equals(this.location, symbol.location);
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        return this.name.hashCode();
    }

    private static final class Dynamic
    extends LLVMSourceSymbol {
        private Dynamic(String name, LLVMSourceLocation location, LLVMSourceType type) {
            super(name, location, type);
        }

        @Override
        public boolean isStatic() {
            return false;
        }
    }

    private static final class Static
    extends LLVMSourceSymbol {
        private Static(String name, LLVMSourceLocation location, LLVMSourceType type) {
            super(name, location, type);
        }

        @Override
        public boolean isStatic() {
            return true;
        }
    }
}

