/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;

public final class ToolchainImpl
implements Toolchain {
    private final ToolchainConfig toolchainConfig;
    private final LLVMLanguage language;

    public ToolchainImpl(ToolchainConfig toolchainConfig, LLVMLanguage language) {
        this.toolchainConfig = toolchainConfig;
        this.language = language;
    }

    public TruffleFile getToolPath(String tool) {
        if (this.toolchainConfig == null) {
            return null;
        }
        switch (tool) {
            case "PATH": {
                return this.getRoot().resolve("bin");
            }
            case "CC": {
                return this.getRoot().resolve("bin").resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang");
            }
            case "CXX": {
                if (!this.toolchainConfig.enableCXX()) {
                    return null;
                }
                return this.getRoot().resolve("bin").resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang++");
            }
            case "LD": {
                return this.getRoot().resolve("bin").resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-ld");
            }
        }
        return null;
    }

    protected TruffleFile getRoot() {
        TruffleLanguage.Env env = LLVMLanguage.getContext().getEnv();
        String toolchainRoot = this.toolchainConfig.getToolchainRootOverride();
        return toolchainRoot != null ? env.getInternalTruffleFile(toolchainRoot) : env.getInternalTruffleFile(this.language.getLLVMLanguageHome()).resolve(this.toolchainConfig.getToolchainSubdir());
    }

    public String getIdentifier() {
        if (this.toolchainConfig == null) {
            return null;
        }
        return this.toolchainConfig.getToolchainSubdir();
    }

    public String toString() {
        return this.toolchainConfig.getClass().getSimpleName();
    }
}

