/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import java.math.BigInteger;

@CompilerDirectives.ValueType
public final class LLVMIVarBitSmall
extends LLVMIVarBit {
    public static final int MAX_SIZE = 64;
    private static final long ALL_BITS = -1L;
    private final int bits;
    private final long value;

    LLVMIVarBitSmall(int bits, long value) {
        this.bits = bits;
        this.value = value;
        assert (bits <= 64);
    }

    LLVMIVarBitSmall(int bits, byte[] arr, int arrBits, boolean signExtend) {
        this.bits = bits;
        long v = 0L;
        for (int i = 0; i < arr.length; ++i) {
            v = v << 8 | (long)(arr[i] & 0xFF);
        }
        if (arrBits < bits) {
            v = LLVMIVarBitSmall.getCleanedValue(v, arrBits, signExtend);
        }
        this.value = v;
        assert (bits <= 64);
    }

    @Override
    public LLVMIVarBitSmall copy() {
        if (CompilerDirectives.inCompiledCode()) {
            return new LLVMIVarBitSmall(this.bits, this.value);
        }
        return this;
    }

    private static long getCleanedValue(long value, int bits, boolean signed) {
        boolean oneExtend;
        boolean bl = oneExtend = signed && (value & (long)(1 << bits - 1)) != 0L;
        if (oneExtend) {
            return value | -1L << bits;
        }
        return value & -1L >>> 64 - bits;
    }

    public long getCleanedValue(boolean signed) {
        return LLVMIVarBitSmall.getCleanedValue(this.value, this.bits, signed);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getByteValue() {
        return (byte)this.getCleanedValue(true);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getZeroExtendedByteValue() {
        return (byte)this.getCleanedValue(false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public short getShortValue() {
        return (short)this.getCleanedValue(true);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public short getZeroExtendedShortValue() {
        return (short)this.getCleanedValue(false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getIntValue() {
        return (int)this.getCleanedValue(true);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getZeroExtendedIntValue() {
        return (int)this.getCleanedValue(false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getLongValue() {
        return this.getCleanedValue(true);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getZeroExtendedLongValue() {
        return this.getCleanedValue(false);
    }

    @Override
    public int getBitSize() {
        return this.bits;
    }

    @Override
    public byte[] getBytes() {
        int byteSize = LLVMIVarBitLarge.getByteSize(this.bits);
        byte[] array = new byte[byteSize];
        long v = this.value;
        for (int i = array.length - 1; i >= 0; --i) {
            array[i] = (byte)v;
            v >>>= 8;
        }
        return array;
    }

    private static LLVMIVarBitSmall cast(LLVMIVarBit ivar) {
        return (LLVMIVarBitSmall)ivar;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall add(LLVMIVarBit right) {
        return this.asIVar(this.value + LLVMIVarBitSmall.cast(right).getCleanedValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall mul(LLVMIVarBit right) {
        return this.asIVar(this.value * LLVMIVarBitSmall.cast(right).getCleanedValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall sub(LLVMIVarBit right) {
        return this.asIVar(this.value - LLVMIVarBitSmall.cast(right).getCleanedValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall div(LLVMIVarBit right) {
        return this.asIVar(this.getCleanedValue(true) / LLVMIVarBitSmall.cast(right).getCleanedValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall rem(LLVMIVarBit right) {
        return this.asIVar(this.getCleanedValue(true) % LLVMIVarBitSmall.cast(right).getCleanedValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall unsignedRem(LLVMIVarBit right) {
        return this.asIVar(Long.remainderUnsigned(this.getCleanedValue(false), LLVMIVarBitSmall.cast(right).getCleanedValue(false)));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall unsignedDiv(LLVMIVarBit right) {
        return this.asIVar(Long.divideUnsigned(this.getCleanedValue(false), LLVMIVarBitSmall.cast(right).getCleanedValue(false)));
    }

    @Override
    public boolean isEqual(LLVMIVarBit o) {
        return this.getCleanedValue(false) == LLVMIVarBitSmall.cast(o).getCleanedValue(false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall and(LLVMIVarBit right) {
        return new LLVMIVarBitSmall(this.bits, this.value & LLVMIVarBitSmall.cast((LLVMIVarBit)right).value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall or(LLVMIVarBit right) {
        return new LLVMIVarBitSmall(this.bits, this.value | LLVMIVarBitSmall.cast((LLVMIVarBit)right).value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall xor(LLVMIVarBit right) {
        return new LLVMIVarBitSmall(this.bits, this.value ^ LLVMIVarBitSmall.cast((LLVMIVarBit)right).value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall leftShift(LLVMIVarBit right) {
        return new LLVMIVarBitSmall(this.bits, this.value << (int)LLVMIVarBitSmall.cast(right).getCleanedValue(false));
    }

    @CompilerDirectives.TruffleBoundary
    private LLVMIVarBitSmall asIVar(long result) {
        return new LLVMIVarBitSmall(this.bits, result);
    }

    static LLVMIVarBitSmall asIVar(int bitSize, BigInteger result) {
        int resultLengthIncludingSign = result.bitLength() + (result.signum() == -1 ? 1 : 0);
        long value = result.longValue();
        if (resultLengthIncludingSign < bitSize) {
            value = LLVMIVarBitSmall.getCleanedValue(value, resultLengthIncludingSign, true);
        }
        return new LLVMIVarBitSmall(bitSize, value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall logicalRightShift(LLVMIVarBit right) {
        return new LLVMIVarBitSmall(this.bits, this.getCleanedValue(false) >>> (int)LLVMIVarBitSmall.cast(right).getCleanedValue(false));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMIVarBitSmall arithmeticRightShift(LLVMIVarBit right) {
        return new LLVMIVarBitSmall(this.bits, this.getCleanedValue(true) >> (int)LLVMIVarBitSmall.cast(right).getCleanedValue(false));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int signedCompare(LLVMIVarBit other) {
        return Long.compare(this.getCleanedValue(true), LLVMIVarBitSmall.cast(other).getCleanedValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int unsignedCompare(LLVMIVarBit other) {
        return Long.compareUnsigned(this.getCleanedValue(false), LLVMIVarBitSmall.cast(other).getCleanedValue(false));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isZero() {
        return this.getCleanedValue(false) == 0L;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.isZero()) {
            return Integer.toString(0);
        }
        return String.format("i%d %s", this.getBitSize(), this.getDebugValue(true));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public BigInteger getDebugValue(boolean signed) {
        if (signed) {
            return BigInteger.valueOf(this.getCleanedValue(true));
        }
        long v = this.getCleanedValue(false);
        return BigInteger.valueOf(v >>> 1).shiftLeft(1).add(BigInteger.valueOf(v & 1L));
    }
}

