/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMUnsupportedException;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugManagedValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMFrameValueAccess;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMSourceTypeFactory;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.interop.convert.ToAnyLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToDoubleNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToFloatNodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI16NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI1NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI32NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI64NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToI8NodeGen;
import com.oracle.truffle.llvm.runtime.interop.convert.ToPointer;
import com.oracle.truffle.llvm.runtime.interop.convert.ToVoidLLVMNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugInitNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugSimpleObjectBuilder;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugTrapNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMDebugWriteNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMFrameValueAccessImpl;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugDeclarationNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDirectLoadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDoubleLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMFloatLoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMLoadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMFloatStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessGlobalVariableStorageNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMUnsupportedInstructionNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMValueProfilingNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.vars.LLVMReadVectorNodeFactory;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.vector.LLVMVector;

public class CommonNodeFactory {
    private static LLVMDebugBuilder debugDeclarationBuilder = null;
    private static LLVMDebugBuilder debugValueBuilder = null;

    public static LLVMLoadNode createLoadNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1LoadNodeGen.create(null);
            }
            case I8: {
                return LLVMI8LoadNodeGen.create(null);
            }
            case I16: {
                return LLVMI16LoadNodeGen.create(null);
            }
            case I32: {
                return LLVMI32LoadNodeGen.create(null);
            }
            case I64: {
                return LLVMI64LoadNodeGen.create(null);
            }
            case FLOAT: {
                return LLVMFloatLoadNodeGen.create(null);
            }
            case DOUBLE: {
                return LLVMDoubleLoadNodeGen.create(null);
            }
            case POINTER: {
                return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(null);
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)kind));
    }

    public static LLVMStoreNode createStoreNode(LLVMInteropType.ValueKind kind) {
        switch (kind) {
            case I1: {
                return LLVMI1StoreNodeGen.create(null, null);
            }
            case I8: {
                return LLVMI8StoreNodeGen.create(null, null);
            }
            case I16: {
                return LLVMI16StoreNodeGen.create(null, null);
            }
            case I32: {
                return LLVMI32StoreNodeGen.create(null, null);
            }
            case I64: {
                return LLVMI64StoreNodeGen.create(null, null);
            }
            case FLOAT: {
                return LLVMFloatStoreNodeGen.create(null, null);
            }
            case DOUBLE: {
                return LLVMDoubleStoreNodeGen.create(null, null);
            }
            case POINTER: {
                return LLVMPointerStoreNodeGen.create(null, null);
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)kind));
    }

    public static TruffleObject toGenericDebuggerValue(Object llvmType, Object value, DataLayout dataLayout) {
        TruffleObject complexObject = CommonNodeFactory.asDebuggerIRValue(llvmType, value, dataLayout);
        if (complexObject != null) {
            return complexObject;
        }
        return LLVMDebugManagedValue.create(llvmType, value);
    }

    private static TruffleObject asDebuggerIRValue(Object llvmType, Object value, DataLayout dataLayout) {
        if (!(llvmType instanceof Type)) {
            return null;
        }
        Type type = (Type)llvmType;
        if (type instanceof MetaType) {
            return null;
        }
        LLVMSourceType sourceType = LLVMSourceTypeFactory.resolveType(type, dataLayout);
        if (sourceType == null) {
            return null;
        }
        if (value instanceof LLVMVector && ((LLVMVector)value).getLength() == 0) {
            return null;
        }
        if (value instanceof LLVMIVarBit && ((LLVMIVarBit)value).getBitSize() == 0) {
            return null;
        }
        LLVMDebugValue debugValue = CommonNodeFactory.createDebugValueBuilder().build(value);
        if (debugValue == LLVMDebugValue.UNAVAILABLE) {
            return null;
        }
        return LLVMDebugObject.instantiate(sourceType, 0L, debugValue, null);
    }

    public static LLVMStatementNode createBasicBlockNode(LLVMStatementNode[] statementNodes, LLVMControlFlowNode terminatorNode, int blockId, String blockName, LLVMContext context) {
        return LLVMBasicBlockNode.createBasicBlockNode(context, statementNodes, terminatorNode, blockId, blockName);
    }

    public static LLVMFrameValueAccess createDebugFrameValue(FrameSlot slot, boolean isDeclaration) {
        LLVMDebugValue.Builder builder = CommonNodeFactory.getDebugDynamicValueBuilder(isDeclaration).createBuilder();
        return new LLVMFrameValueAccessImpl(slot, builder);
    }

    private static LLVMDebugBuilder getDebugDynamicValueBuilder(boolean isDeclaration) {
        if (isDeclaration) {
            if (debugDeclarationBuilder == null) {
                debugDeclarationBuilder = LLVMDebugBuilder.createDeclaration();
            }
            return debugDeclarationBuilder;
        }
        if (debugValueBuilder == null) {
            debugValueBuilder = LLVMDebugBuilder.createValue();
        }
        return debugValueBuilder;
    }

    public static LLVMDebugObjectBuilder createDebugStaticValue(LLVMExpressionNode valueNode, boolean isGlobal) {
        LLVMDebugValue.Builder toDebugNode = CommonNodeFactory.createDebugValueBuilder();
        Object value = null;
        if (isGlobal) {
            assert (valueNode instanceof LLVMAccessGlobalVariableStorageNode);
            LLVMAccessGlobalVariableStorageNode node = (LLVMAccessGlobalVariableStorageNode)valueNode;
            value = new LLVMDebugGlobalVariable(node.getDescriptor());
        } else {
            try {
                value = valueNode.executeGeneric(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (value != null) {
            return LLVMDebugSimpleObjectBuilder.create(toDebugNode, value);
        }
        return LLVMDebugObjectBuilder.UNAVAILABLE;
    }

    public static LLVMStatementNode createDebugValueInit(FrameSlot targetSlot, int[] offsets, int[] lengths) {
        if (offsets == null || lengths == null) {
            return null;
        }
        return LLVMDebugInitNodeFactory.AggregateInitNodeGen.create(targetSlot, offsets, lengths);
    }

    public static LLVMExpressionNode createFrameRead(Type llvmType, FrameSlot frameSlot) {
        if (llvmType instanceof PrimitiveType) {
            switch (((PrimitiveType)llvmType).getPrimitiveKind()) {
                case I1: {
                    return LLVMReadNodeFactory.LLVMI1ReadNodeGen.create(frameSlot);
                }
                case I8: {
                    return LLVMReadNodeFactory.LLVMI8ReadNodeGen.create(frameSlot);
                }
                case I16: {
                    return LLVMReadNodeFactory.LLVMI16ReadNodeGen.create(frameSlot);
                }
                case I32: {
                    return LLVMReadNodeFactory.LLVMI32ReadNodeGen.create(frameSlot);
                }
                case I64: {
                    return LLVMReadNodeFactory.LLVMI64ReadNodeGen.create(frameSlot);
                }
                case FLOAT: {
                    return LLVMReadNodeFactory.LLVMFloatReadNodeGen.create(frameSlot);
                }
                case DOUBLE: {
                    return LLVMReadNodeFactory.LLVMDoubleReadNodeGen.create(frameSlot);
                }
                case X86_FP80: {
                    return LLVMReadNodeFactory.LLVM80BitFloatReadNodeGen.create(frameSlot);
                }
            }
        } else if (llvmType instanceof VectorType) {
            Type elemType = ((VectorType)llvmType).getElementType();
            if (elemType instanceof PrimitiveType) {
                switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                    case I1: {
                        return LLVMReadVectorNodeFactory.LLVMI1VectorReadNodeGen.create(frameSlot);
                    }
                    case I8: {
                        return LLVMReadVectorNodeFactory.LLVMI8VectorReadNodeGen.create(frameSlot);
                    }
                    case I16: {
                        return LLVMReadVectorNodeFactory.LLVMI16VectorReadNodeGen.create(frameSlot);
                    }
                    case I32: {
                        return LLVMReadVectorNodeFactory.LLVMI32VectorReadNodeGen.create(frameSlot);
                    }
                    case I64: {
                        return LLVMReadVectorNodeFactory.LLVMI64VectorReadNodeGen.create(frameSlot);
                    }
                    case FLOAT: {
                        return LLVMReadVectorNodeFactory.LLVMFloatVectorReadNodeGen.create(frameSlot);
                    }
                    case DOUBLE: {
                        return LLVMReadVectorNodeFactory.LLVMDoubleVectorReadNodeGen.create(frameSlot);
                    }
                }
            } else if (elemType instanceof PointerType || elemType instanceof FunctionType) {
                return LLVMReadVectorNodeFactory.LLVMI64VectorReadNodeGen.create(frameSlot);
            }
        } else {
            if (llvmType instanceof VariableBitWidthType) {
                return LLVMReadNodeFactory.LLVMIReadVarBitNodeGen.create(frameSlot);
            }
            if (llvmType instanceof PointerType || llvmType instanceof FunctionType) {
                return LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frameSlot);
            }
            if (llvmType instanceof StructureType || llvmType instanceof ArrayType) {
                return LLVMReadNodeFactory.LLVMAddressReadNodeGen.create(frameSlot);
            }
            if (llvmType instanceof VoidType) {
                return LLVMUnsupportedInstructionNode.createExpression(LLVMUnsupportedException.UnsupportedReason.PARSER_ERROR_VOID_SLOT);
            }
            if (llvmType == MetaType.DEBUG) {
                return LLVMReadNodeFactory.LLVMDebugReadNodeGen.create(frameSlot);
            }
        }
        throw new AssertionError((Object)(llvmType + " for " + frameSlot.getIdentifier()));
    }

    public static LLVMStatementNode createDebugValueUpdate(boolean isDeclaration, LLVMExpressionNode valueRead, FrameSlot targetSlot, LLVMExpressionNode containerRead, int partIndex, int[] clearParts) {
        LLVMDebugBuilder builder = CommonNodeFactory.getDebugDynamicValueBuilder(isDeclaration);
        if (partIndex < 0 || clearParts == null) {
            return LLVMDebugWriteNodeFactory.SimpleWriteNodeGen.create(builder, targetSlot, valueRead);
        }
        return LLVMDebugWriteNodeFactory.AggregateWriteNodeGen.create(builder, partIndex, clearParts, containerRead, valueRead);
    }

    public static LLVMLoadNode createLoad(Type resolvedResultType, LLVMExpressionNode loadTarget) {
        if (resolvedResultType instanceof VectorType) {
            return CommonNodeFactory.createLoadVector((VectorType)resolvedResultType, loadTarget, ((VectorType)resolvedResultType).getNumberOfElements());
        }
        int bits = resolvedResultType instanceof VariableBitWidthType ? resolvedResultType.getBitSize() : 0;
        return CommonNodeFactory.createLoad(resolvedResultType, loadTarget, bits);
    }

    private static LLVMLoadNode createLoadVector(VectorType resultType, LLVMExpressionNode loadTarget, int size) {
        Type elemType = resultType.getElementType();
        if (elemType instanceof PrimitiveType) {
            switch (((PrimitiveType)elemType).getPrimitiveKind()) {
                case I1: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI1VectorNodeGen.create(loadTarget, size);
                }
                case I8: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI8VectorNodeGen.create(loadTarget, size);
                }
                case I16: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI16VectorNodeGen.create(loadTarget, size);
                }
                case I32: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI32VectorNodeGen.create(loadTarget, size);
                }
                case I64: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadI64VectorNodeGen.create(loadTarget, size);
                }
                case FLOAT: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadFloatVectorNodeGen.create(loadTarget, size);
                }
                case DOUBLE: {
                    return LLVMLoadVectorNodeFactory.LLVMLoadDoubleVectorNodeGen.create(loadTarget, size);
                }
            }
            throw new AssertionError((Object)(elemType + " vectors not supported"));
        }
        if (elemType instanceof PointerType || elemType instanceof FunctionType) {
            return LLVMLoadVectorNodeFactory.LLVMLoadPointerVectorNodeGen.create(loadTarget, size);
        }
        throw new AssertionError((Object)(elemType + " vectors not supported"));
    }

    private static LLVMLoadNode createLoad(Type resultType, LLVMExpressionNode loadTarget, int bits) {
        if (resultType instanceof PrimitiveType) {
            switch (((PrimitiveType)resultType).getPrimitiveKind()) {
                case I1: {
                    return LLVMI1LoadNodeGen.create(loadTarget);
                }
                case I8: {
                    return LLVMI8LoadNodeGen.create(loadTarget);
                }
                case I16: {
                    return LLVMI16LoadNodeGen.create(loadTarget);
                }
                case I32: {
                    return LLVMI32LoadNodeGen.create(loadTarget);
                }
                case I64: {
                    return LLVMI64LoadNodeGen.create(loadTarget);
                }
                case FLOAT: {
                    return LLVMFloatLoadNodeGen.create(loadTarget);
                }
                case DOUBLE: {
                    return LLVMDoubleLoadNodeGen.create(loadTarget);
                }
                case X86_FP80: {
                    return LLVMDirectLoadNodeFactory.LLVM80BitFloatDirectLoadNodeGen.create(loadTarget);
                }
            }
            throw new AssertionError(resultType);
        }
        if (resultType instanceof VariableBitWidthType) {
            return LLVMDirectLoadNodeFactory.LLVMIVarBitDirectLoadNodeGen.create(loadTarget, bits);
        }
        if (resultType instanceof StructureType || resultType instanceof ArrayType) {
            return LLVMDirectLoadNodeFactory.LLVMStructDirectLoadNodeGen.create(loadTarget);
        }
        if (resultType instanceof PointerType || resultType instanceof FunctionType) {
            return LLVMDirectLoadNodeFactory.LLVMPointerDirectLoadNodeGen.create(loadTarget);
        }
        throw new AssertionError(resultType);
    }

    public static ForeignToLLVM createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType type) {
        switch (type) {
            case VOID: {
                return ToVoidLLVMNodeGen.create();
            }
            case ANY: {
                return ToAnyLLVMNodeGen.create();
            }
            case I1: {
                return ToI1NodeGen.create();
            }
            case I8: {
                return ToI8NodeGen.create();
            }
            case I16: {
                return ToI16NodeGen.create();
            }
            case I32: {
                return ToI32NodeGen.create();
            }
            case I64: {
                return ToI64NodeGen.create();
            }
            case FLOAT: {
                return ToFloatNodeGen.create();
            }
            case DOUBLE: {
                return ToDoubleNodeGen.create();
            }
            case POINTER: {
                return ToPointer.create();
            }
        }
        throw new IllegalStateException(type.toString());
    }

    public static ForeignToLLVM createForeignToLLVM(LLVMInteropType.Value type) {
        switch (type.getKind()) {
            case I1: {
                return ToI1NodeGen.create();
            }
            case I8: {
                return ToI8NodeGen.create();
            }
            case I16: {
                return ToI16NodeGen.create();
            }
            case I32: {
                return ToI32NodeGen.create();
            }
            case I64: {
                return ToI64NodeGen.create();
            }
            case FLOAT: {
                return ToFloatNodeGen.create();
            }
            case DOUBLE: {
                return ToDoubleNodeGen.create();
            }
            case POINTER: {
                return ToPointer.create(type.getBaseType());
            }
        }
        throw new IllegalStateException("unexpected interop kind " + (Object)((Object)type.getKind()));
    }

    public static LLVMExpressionNode createFunctionCall(LLVMExpressionNode functionNode, LLVMExpressionNode[] argNodes, FunctionType type) {
        LLVMCallNode callNode = new LLVMCallNode(type, functionNode, argNodes, true);
        return LLVMValueProfilingNode.create(callNode, type.getReturnType());
    }

    public static LLVMStatementNode createDebugTrap() {
        return new LLVMDebugTrapNode();
    }

    public static LLVMDebugValue.Builder createDebugDeclarationBuilder() {
        return LLVMToDebugDeclarationNodeGen.create();
    }

    public static LLVMDebugValue.Builder createDebugValueBuilder() {
        return LLVMToDebugValueNodeGen.create();
    }
}

