/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.text;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.text.LLInstructionMapper;
import com.oracle.truffle.llvm.parser.text.LLScanner;
import com.oracle.truffle.llvm.parser.text.LLSourceMap;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;

public final class LLSourceBuilder {
    private final String bcPath;
    private LLSourceMap cached = null;

    public static LLSourceBuilder create(Source bcSource) {
        String bcPath = bcSource != null ? bcSource.getPath() : null;
        return new LLSourceBuilder(bcPath);
    }

    private LLSourceBuilder(String bcPath) {
        this.bcPath = bcPath;
    }

    public void applySourceLocations(FunctionDefinition function, LLVMParserRuntime runtime) {
        if (this.cached == null) {
            String pathMappings = (String)runtime.getContext().getEnv().getOptions().get(SulongEngineOption.LL_DEBUG_SOURCES);
            this.cached = LLScanner.findAndScanLLFile(this.bcPath, pathMappings, runtime.getContext());
            assert (this.cached != null);
        }
        if (this.cached != LLScanner.NOT_FOUND) {
            LLInstructionMapper.setSourceLocations(this.cached, function, runtime);
        }
    }
}

