/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.scanner;

import org.graalvm.polyglot.io.ByteSequence;

public final class BitStream {
    private static final int BYTE_BITS_SHIFT = 3;
    private static final int BYTE_BITS_MASK = 7;
    private static final long BYTE_MASK = 255L;
    private final ByteSequence bitstream;

    private BitStream(ByteSequence bitstream) {
        this.bitstream = bitstream;
    }

    public static BitStream create(ByteSequence bytes) {
        return new BitStream(bytes);
    }

    public static BitStream createFromBlob(long[] args, int blobStartIndex) {
        byte[] blob = new byte[(args.length - blobStartIndex) * 8];
        int to = 0;
        for (int from = blobStartIndex; from < args.length; ++from) {
            long l = args[from];
            for (int i = 0; i < 8; ++i) {
                blob[to++] = (byte)(l >> 8 * i & 0xFFL);
            }
        }
        return new BitStream(ByteSequence.create((byte[])blob));
    }

    public static long widthVBR(long value, long width) {
        long total = 0L;
        long v = value;
        do {
            total += width;
        } while ((v >>>= (int)(width - 1L)) != 0L);
        return total;
    }

    public long read(long offset, int bits) {
        byte byteValue;
        int byteIndex = (int)(offset >> 3);
        int bitOffsetInByte = (int)(offset & 7L);
        int availableBits = 8 - bitOffsetInByte;
        long value = ((long)this.bitstream.byteAt(byteIndex++) & 0xFFL) >> bitOffsetInByte;
        if (bits <= availableBits) {
            return value & 255L >> 8 - bits;
        }
        int remainingBits = bits - availableBits;
        int shift = availableBits;
        while (true) {
            byteValue = this.bitstream.byteAt(byteIndex++);
            if (remainingBits <= 8) break;
            value |= ((long)byteValue & 0xFFL) << shift;
            remainingBits -= 8;
            shift += 8;
        }
        return value | ((long)byteValue & 255L >> 8 - remainingBits) << shift;
    }

    public long readVBR(long offset, int width) {
        long datum;
        long value = 0L;
        long shift = 0L;
        long o = offset;
        long dmask = 1 << width - 1;
        do {
            datum = this.read(o, width);
            o += (long)width;
            value += (datum & dmask - 1L) << (int)shift;
            shift += (long)(width - 1);
        } while ((datum & dmask) != 0L);
        return value;
    }

    public long size() {
        return (long)this.bitstream.length() * 8L;
    }
}

