/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Call;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Invoke;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class VoidInvokeInstruction
extends VoidInstruction
implements Invoke {
    private SymbolImpl target;
    private final SymbolImpl[] arguments;
    private final InstructionBlock normalSuccessor;
    private final InstructionBlock unwindSuccessor;
    private final AttributesCodeEntry paramAttr;

    private VoidInvokeInstruction(InstructionBlock normalSuccessor, InstructionBlock unwindSuccessor, AttributesCodeEntry paramAttr, int argCount) {
        this.normalSuccessor = normalSuccessor;
        this.unwindSuccessor = unwindSuccessor;
        this.paramAttr = paramAttr;
        this.arguments = argCount == 0 ? NO_ARGS : new SymbolImpl[argCount];
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SymbolImpl[] getArguments() {
        return this.arguments;
    }

    @Override
    public SymbolImpl getCallTarget() {
        return this.target;
    }

    @Override
    public AttributesGroup getFunctionAttributesGroup() {
        return this.paramAttr.getFunctionAttributesGroup();
    }

    @Override
    public AttributesGroup getReturnAttributesGroup() {
        return this.paramAttr.getReturnAttributesGroup();
    }

    @Override
    public AttributesGroup getParameterAttributesGroup(int idx) {
        return this.paramAttr.getParameterAttributesGroup(idx);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.target == original) {
            this.target = replacement;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != original) continue;
            this.arguments[i] = replacement;
        }
    }

    public static VoidInvokeInstruction fromSymbols(IRScope scope, int targetIndex, int[] arguments, InstructionBlock normalSuccessor, InstructionBlock unwindSuccessor, AttributesCodeEntry paramAttr) {
        VoidInvokeInstruction inst = new VoidInvokeInstruction(normalSuccessor, unwindSuccessor, paramAttr, arguments.length);
        inst.target = scope.getSymbols().getForwardReferenced(targetIndex, inst);
        Call.parseArguments(scope, inst.target, inst, inst.arguments, arguments);
        return inst;
    }

    @Override
    public InstructionBlock normalSuccessor() {
        return this.normalSuccessor;
    }

    @Override
    public InstructionBlock unwindSuccessor() {
        return this.unwindSuccessor;
    }

    @Override
    public int getSuccessorCount() {
        return 2;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        if (index == 0) {
            return this.normalSuccessor;
        }
        assert (index == 1);
        return this.unwindSuccessor;
    }

    public String toString() {
        return String.format("%s -> %s : %s", Call.asString(this.target, this.arguments), this.normalSuccessor.getName(), this.unwindSuccessor.getName());
    }
}

