/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.metadata.MetadataSymbol;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.Type;

public interface Call
extends SymbolImpl {
    public static final SymbolImpl[] NO_ARGS = new SymbolImpl[0];

    public static void parseArguments(IRScope scope, SymbolImpl callTarget, Instruction inst, SymbolImpl[] target, int[] src) {
        int i;
        if (src.length == 0) {
            return;
        }
        Type[] paramTypes = callTarget instanceof FunctionDefinition ? ((FunctionDefinition)callTarget).getType().getArgumentTypes() : (callTarget instanceof FunctionDeclaration ? ((FunctionDeclaration)callTarget).getType().getArgumentTypes() : Type.EMPTY_ARRAY);
        SymbolTable symbols = scope.getSymbols();
        for (i = Math.min(paramTypes.length, src.length) - 1; i >= 0; --i) {
            target[i] = paramTypes[i] == MetaType.METADATA ? MetadataSymbol.create(scope.getMetadata(), src[i]) : (SymbolImpl)symbols.getForwardReferenced(src[i], inst);
        }
        for (i = paramTypes.length; i < src.length; ++i) {
            target[i] = symbols.getForwardReferenced(src[i], inst);
        }
    }

    public static String asString(SymbolImpl target, SymbolImpl[] arguments) {
        StringBuilder sb = new StringBuilder();
        if (target instanceof FunctionDeclaration) {
            sb.append(((FunctionDeclaration)target).getName());
        } else if (target instanceof FunctionDefinition) {
            sb.append(((FunctionDefinition)target).getName());
        } else {
            sb.append(target);
        }
        sb.append('(');
        for (int i = 0; i < arguments.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arguments[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public SymbolImpl[] getArguments();

    default public SymbolImpl getArgument(int index) {
        return this.getArguments()[index];
    }

    default public int getArgumentCount() {
        return this.getArguments().length;
    }

    public SymbolImpl getCallTarget();

    public AttributesGroup getFunctionAttributesGroup();

    public AttributesGroup getReturnAttributesGroup();

    public AttributesGroup getParameterAttributesGroup(int var1);
}

