/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.ArrayType;

public final class StringConstant
extends AbstractConstant {
    private final String value;
    private final boolean isCString;

    public StringConstant(ArrayType type, String value, boolean isCString) {
        super(type);
        this.value = value;
        this.isCString = isCString;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public String getString() {
        return this.value;
    }

    public boolean isCString() {
        return this.isCString;
    }

    @Override
    public ArrayType getType() {
        return (ArrayType)super.getType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("c\"");
        for (int i = 0; i < this.value.length(); ++i) {
            byte b = (byte)this.value.charAt(i);
            if (b < 32 || b >= 126) {
                sb.append(String.format("\\%02X", b));
                continue;
            }
            sb.append((char)b);
        }
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }
}

