/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.enums.AsmDialect;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class InlineAsmConstant
extends AbstractConstant {
    private static final char DELIMITER = '\"';
    private final String asmExpression;
    private final String asmFlags;
    private final AsmDialect dialect;
    private final boolean hasSideEffects;
    private final boolean stackAlign;

    private InlineAsmConstant(Type type, String asmExpression, String asmFlags, boolean hasSideEffects, boolean stackAlign, AsmDialect dialect) {
        super(type);
        this.asmExpression = asmExpression;
        this.asmFlags = asmFlags;
        this.hasSideEffects = hasSideEffects;
        this.stackAlign = stackAlign;
        this.dialect = dialect;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public String getAsmExpression() {
        return this.asmExpression;
    }

    public String getAsmFlags() {
        return this.asmFlags;
    }

    public AsmDialect getDialect() {
        return this.dialect;
    }

    public boolean hasSideEffects() {
        return this.hasSideEffects;
    }

    public boolean needsAlignedStack() {
        return this.stackAlign;
    }

    public String toString() {
        return "asm";
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    public static InlineAsmConstant createFromData(Type type, RecordBuffer buffer) {
        int flags = buffer.readInt();
        boolean hasSideEffects = (flags & 1) == 1;
        boolean stackAlign = (flags & 2) == 2;
        long asmDialect = flags >> 2;
        int expressionStringLength = buffer.readInt();
        StringBuilder asmExpressionBuilder = new StringBuilder(expressionStringLength + 2);
        asmExpressionBuilder.append('\"');
        while (expressionStringLength-- > 0) {
            asmExpressionBuilder.append((char)buffer.read());
        }
        asmExpressionBuilder.append('\"');
        int flagsStringLength = buffer.readInt();
        StringBuilder asmFlagsBuilder = new StringBuilder(flagsStringLength + 2);
        asmFlagsBuilder.append('\"');
        while (flagsStringLength-- > 0) {
            asmFlagsBuilder.append((char)buffer.read());
        }
        asmFlagsBuilder.append('\"');
        String asmExpression = asmExpressionBuilder.toString();
        String asmFlags = asmFlagsBuilder.toString();
        return new InlineAsmConstant(type, asmExpression, asmFlags, hasSideEffects, stackAlign, AsmDialect.decode(asmDialect));
    }
}

