/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class BlockAddressConstant
extends AbstractConstant {
    private FunctionDefinition function;
    private final int block;

    private BlockAddressConstant(Type type, int block) {
        super(type);
        this.block = block;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    public int getBlockIndex() {
        return this.block;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.function == original) {
            if (replacement instanceof FunctionDefinition) {
                this.function = (FunctionDefinition)replacement;
            } else {
                throw new LLVMParserException("Illegal symbol for function in BlockAddressConstant: " + replacement);
            }
        }
    }

    public static BlockAddressConstant fromSymbols(SymbolTable symbols, Type type, int function, int block) {
        BlockAddressConstant constant = new BlockAddressConstant(type, block);
        SymbolImpl functionSymbol = symbols.getForwardReferenced(function, constant);
        if (!(functionSymbol instanceof FunctionDefinition)) {
            throw new LLVMParserException("Illegal symbol for function in BlockAddressConstant: " + functionSymbol);
        }
        constant.function = (FunctionDefinition)functionSymbol;
        return constant;
    }
}

