/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.attributes;

import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class Attribute {
    public abstract String getIrString();

    public static final class StringValueAttribute
    extends StringAttribute {
        private final String value;

        public StringValueAttribute(String stringAttr, String value) {
            super(stringAttr);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public String getIrString() {
            return String.format("\"%s\"=\"%s\"", this.stringAttr, this.value);
        }
    }

    public static class StringAttribute
    extends Attribute {
        protected final String stringAttr;

        public StringAttribute(String stringAttr) {
            this.stringAttr = stringAttr;
        }

        @Override
        public String getIrString() {
            return String.format("\"%s\"", this.stringAttr);
        }
    }

    public static final class KnownIntegerValueAttribute
    extends KnownAttribute {
        private final int value;

        public KnownIntegerValueAttribute(Kind paramAttr, int value) {
            super(paramAttr);
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public String getIrString() {
            if (this.paramAttr == Kind.ALIGN) {
                return String.format("%s %d", this.paramAttr.getIrString(), this.value);
            }
            return String.format("%s(%d)", this.paramAttr.getIrString(), this.value);
        }
    }

    public static class KnownTypedAttribute
    extends KnownAttribute {
        private final Type type;

        public KnownTypedAttribute(Kind paramAttr, Type type) {
            super(paramAttr);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static class KnownAttribute
    extends Attribute {
        protected final Kind paramAttr;

        public KnownAttribute(Kind paramAttr) {
            this.paramAttr = paramAttr;
        }

        public Kind getAttr() {
            return this.paramAttr;
        }

        @Override
        public String getIrString() {
            return this.paramAttr.getIrString();
        }
    }

    public static enum Kind {
        NONE,
        ALIGN,
        ALWAYSINLINE,
        BYVAL,
        INLINEHINT,
        INREG,
        MINSIZE,
        NAKED,
        NEST,
        NOALIAS,
        NOBUILTIN,
        NOCAPTURE,
        NODUPLICATES,
        NOIMPLICITFLOAT,
        NOINLINE,
        NONLAZYBIND,
        NOREDZONE,
        NORETURN,
        NOUNWIND,
        OPTSIZE,
        READNONE,
        READONLY,
        RETURNED,
        RETURNS_TWICE,
        SIGNEXT,
        ALIGNSTACK,
        SSP,
        SSPREQ,
        SSPSTRONG,
        SRET,
        SANITIZE_ADDRESS,
        SANITIZE_THREAD,
        SANITIZE_MEMORY,
        UWTABLE,
        ZEROEXT,
        BUILTIN,
        COLD,
        OPTNONE,
        INALLOCA,
        NONNULL,
        JUMPTABLE,
        DEREFERENCEABLE,
        DEREFERENCEABLE_OR_NULL,
        CONVERGENT,
        SAFESTACK,
        ARGMEMONLY,
        SWIFTSELF,
        SWIFTERROR,
        NORECURSE,
        INACCESSIBLEMEMONLY,
        INACCESSIBLEMEM_OR_ARGMEMONLY,
        ALLOCSIZE,
        WRITEONLY,
        SPECULATABLE;

        private static final Kind[] VALUES;

        public static Kind decode(long id) {
            if (id > 0L && id < (long)VALUES.length) {
                return VALUES[(int)id];
            }
            return NONE;
        }

        public String getIrString() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = Kind.values();
        }
    }
}

