/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.debuginfo.ValueFragment;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.UndefinedConstant;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class SourceVariable
implements SymbolImpl {
    private final LLVMSourceSymbol symbol;
    private HashSet<DbgDeclareInstruction> declarations;
    private HashSet<DbgValueInstruction> values;
    private List<ValueFragment> fragments;
    private boolean hasFullDefinition;
    private boolean hasStaticValue;

    SourceVariable(LLVMSourceSymbol symbol) {
        this.symbol = symbol;
        this.fragments = null;
        this.hasFullDefinition = false;
        this.hasStaticValue = false;
    }

    public LLVMSourceSymbol getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public LLVMSourceType getSourceType() {
        return this.symbol.getType();
    }

    public boolean hasFragments() {
        return this.fragments != null;
    }

    public int getFragmentIndex(int offset, int length) {
        if (this.fragments != null) {
            for (int i = 0; i < this.fragments.size(); ++i) {
                ValueFragment fragment = this.fragments.get(i);
                if (fragment.getOffset() != offset || fragment.getLength() != length) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean hasDeclaration() {
        return this.declarations != null && !this.declarations.isEmpty();
    }

    public boolean hasValue() {
        return this.values != null && !this.values.isEmpty();
    }

    public List<ValueFragment> getFragments() {
        return this.fragments != null ? this.fragments : Collections.emptyList();
    }

    public boolean isSingleDeclaration() {
        return this.declarations != null && this.declarations.size() == 1 && !this.hasValue();
    }

    public DbgDeclareInstruction getSingleDeclaration() {
        return this.isSingleDeclaration() ? this.declarations.iterator().next() : null;
    }

    public boolean isSingleValue() {
        if (this.values == null || this.values.size() != 1 || this.fragments != null) {
            return false;
        }
        if (this.declarations == null || this.declarations.isEmpty()) {
            return true;
        }
        if (this.declarations.size() == 1) {
            DbgDeclareInstruction dbgDeclare = this.declarations.iterator().next();
            return dbgDeclare.getValue() instanceof UndefinedConstant;
        }
        return false;
    }

    public DbgValueInstruction getSingleValue() {
        return this.isSingleValue() ? this.values.iterator().next() : null;
    }

    public boolean hasStaticAllocation() {
        return this.hasStaticValue;
    }

    public void addStaticValue() {
        this.hasStaticValue = true;
    }

    void addDeclaration(DbgDeclareInstruction dbg) {
        if (this.declarations == null) {
            this.declarations = new HashSet();
        }
        this.declarations.add(dbg);
    }

    void addValue(DbgValueInstruction dbg) {
        if (this.values == null) {
            this.values = new HashSet();
        }
        this.values.add(dbg);
    }

    void addFullDefinition() {
        this.hasFullDefinition = true;
    }

    void addFragment(ValueFragment fragment) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<ValueFragment>();
        }
        if (!this.fragments.contains(fragment)) {
            this.fragments.add(fragment);
        }
    }

    void processFragments() {
        if (this.fragments != null) {
            if (this.hasFullDefinition) {
                this.addFragment(ValueFragment.create(0, (int)this.symbol.getType().getSize()));
            }
            Collections.sort(this.fragments);
        }
    }

    @Override
    public Type getType() {
        return MetaType.DEBUG;
    }

    public String toString() {
        return this.symbol.getName();
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }
}

