/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDModule;
import com.oracle.truffle.llvm.parser.metadata.MDNamespace;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoCache;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;

final class ImportsProcessor
implements MetadataVisitor {
    private final LLVMContext context;
    private final DebugInfoCache cache;

    static void process(MetadataValueList metadata, LLVMContext context, DebugInfoCache cache) {
        metadata.consumeExportedScopes(new ImportsProcessor(context, cache));
    }

    private ImportsProcessor(LLVMContext context, DebugInfoCache cache) {
        this.context = context;
        this.cache = cache;
    }

    @Override
    public void visit(MDModule md) {
        this.importScope(md, md.getName());
    }

    @Override
    public void visit(MDNamespace md) {
        this.importScope(md, md.getName());
    }

    private void importScope(MDBaseNode scopeNode, MDBaseNode scopeName) {
        String name = MDString.getIfInstance(scopeName);
        if (name == null) {
            return;
        }
        LLVMSourceLocation importedScope = this.context.getSourceContext().getExportedScope(name);
        if (importedScope != null) {
            this.cache.importScope(scopeNode, importedScope);
        } else {
            LLVMSourceLocation exportableScope = this.cache.buildLocation(scopeNode);
            this.context.getSourceContext().exportScope(name, exportableScope);
        }
    }
}

