/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDBasicType;
import com.oracle.truffle.llvm.parser.metadata.MDCommonBlock;
import com.oracle.truffle.llvm.parser.metadata.MDCompileUnit;
import com.oracle.truffle.llvm.parser.metadata.MDCompositeType;
import com.oracle.truffle.llvm.parser.metadata.MDDerivedType;
import com.oracle.truffle.llvm.parser.metadata.MDFile;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariableExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLabel;
import com.oracle.truffle.llvm.parser.metadata.MDLexicalBlock;
import com.oracle.truffle.llvm.parser.metadata.MDLexicalBlockFile;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDLocation;
import com.oracle.truffle.llvm.parser.metadata.MDMacroFile;
import com.oracle.truffle.llvm.parser.metadata.MDModule;
import com.oracle.truffle.llvm.parser.metadata.MDNamespace;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.MDNameExtractor;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

final class DIScopeBuilder {
    private static final String MIMETYPE_PLAINTEXT = "text/plain";
    private static final String MIMETYPE_UNAVAILABLE = "sulong/unavailable";
    private static final String STDIN_FILENAME = "-";
    private static final String STDIN_SOURCE_TEXT = "STDIN";
    private static final String RELPATH_PREFIX = "truffle-relpath://";
    private static final String RELPATH_PROPERTY_SEPARATOR = "//";
    private final HashMap<MDBaseNode, LLVMSourceLocation> globalCache;
    private final HashMap<MDBaseNode, LLVMSourceLocation> localCache;
    private final HashMap<MDFile, TruffleFile> sourceFiles;
    private final HashMap<String, Source> sources;
    private final MetadataValueList metadata;
    private final FileExtractor fileExtractor;
    private final LLVMContext context;

    static String getMimeType(String path) {
        if (path == null) {
            return MIMETYPE_PLAINTEXT;
        }
        int extStartIndex = path.lastIndexOf(46) + 1;
        if (extStartIndex <= 0 || extStartIndex >= path.length()) {
            return MIMETYPE_PLAINTEXT;
        }
        switch (path.substring(extStartIndex)) {
            case "c": 
            case "C": 
            case "cpp": {
                return "text/x-c";
            }
            case "h": {
                return "text/x-h";
            }
            case "f": 
            case "f90": 
            case "for": {
                return "text/x-fortran";
            }
            case "rs": {
                return "text/x-rust";
            }
            case "ll": {
                return "text/x-llvmir";
            }
        }
        return MIMETYPE_PLAINTEXT;
    }

    private TruffleFile resolveAsTruffleRelativePath(String name) {
        if (!name.startsWith(RELPATH_PREFIX)) {
            return null;
        }
        int propertyEndIndex = name.indexOf(RELPATH_PROPERTY_SEPARATOR, RELPATH_PREFIX.length());
        if (propertyEndIndex == -1) {
            throw new LLVMParserException(String.format("Invalid Source Path: \"%s\"", name));
        }
        String property = name.substring(RELPATH_PREFIX.length(), propertyEndIndex);
        if (property.isEmpty()) {
            throw new LLVMParserException(String.format("Invalid Property: \"%s\" from \"%s\"", property, name));
        }
        String pathPrefix = System.getProperty(property);
        if (pathPrefix == null) {
            throw new LLVMParserException(String.format("Property not found: \"%s\" from \"%s\"", property, name));
        }
        int pathStartIndex = propertyEndIndex + RELPATH_PROPERTY_SEPARATOR.length();
        if (pathStartIndex >= name.length()) {
            throw new LLVMParserException(String.format("Invalid Source Path: \"%s\"", name));
        }
        String relativePath = name.substring(pathStartIndex);
        try {
            return this.context.getEnv().getInternalTruffleFile(pathPrefix).resolve(relativePath);
        }
        catch (InvalidPathException ex) {
            throw new LLVMParserException(ex.getMessage());
        }
    }

    private TruffleFile resolveWithSourcePath(String name, MDBaseNode directoryNode) {
        String[] sourcePathList;
        Path path;
        if (STDIN_FILENAME.equals(name)) {
            return null;
        }
        try {
            path = Paths.get(name, new String[0]);
        }
        catch (InvalidPathException ipe) {
            return null;
        }
        TruffleLanguage.Env env = this.context.getEnv();
        if (path.isAbsolute()) {
            return env.getInternalTruffleFile(path.toUri());
        }
        for (String sourcePath : sourcePathList = ((String)env.getOptions().get(SulongEngineOption.SOURCE_PATH)).split(":")) {
            try {
                Path absPath = Paths.get(sourcePath, name);
                TruffleFile file = env.getInternalTruffleFile(absPath.toUri());
                if (!file.exists(new LinkOption[0])) continue;
                return file;
            }
            catch (SecurityException | InvalidPathException runtimeException) {
                // empty catch block
            }
        }
        String directory = MDString.getIfInstance(directoryNode);
        if (directory != null) {
            try {
                Path absPath = Paths.get(directory, name);
                TruffleFile file = env.getInternalTruffleFile(absPath.toUri());
                if (file.exists(new LinkOption[0])) {
                    return file;
                }
            }
            catch (SecurityException | InvalidPathException runtimeException) {
                // empty catch block
            }
        }
        return env.getInternalTruffleFile(name);
    }

    private TruffleFile getSourceFile(MDFile file) {
        if (this.sourceFiles.containsKey(file)) {
            return this.sourceFiles.get(file);
        }
        String name = MDString.getIfInstance(file.getFile());
        TruffleFile sourceFile = this.resolveAsTruffleRelativePath(name);
        if (sourceFile == null) {
            sourceFile = this.resolveWithSourcePath(name, file.getDirectory());
        }
        this.sourceFiles.put(file, sourceFile);
        return sourceFile;
    }

    DIScopeBuilder(MetadataValueList metadata, LLVMContext context) {
        this.metadata = metadata;
        this.fileExtractor = new FileExtractor();
        this.globalCache = new HashMap();
        this.localCache = new HashMap();
        this.sourceFiles = new HashMap();
        this.sources = new HashMap();
        this.context = context;
    }

    private static boolean isLocalScope(LLVMSourceLocation location) {
        switch (location.getKind()) {
            case LINE: 
            case LOCAL: {
                return true;
            }
        }
        return false;
    }

    LLVMSourceLocation buildLocation(MDBaseNode md) {
        if (this.globalCache.containsKey(md)) {
            return this.globalCache.get(md);
        }
        if (this.localCache.containsKey(md)) {
            return this.localCache.get(md);
        }
        Builder builder = new Builder();
        md.accept(builder);
        LLVMSourceLocation location = builder.build();
        if (DIScopeBuilder.isLocalScope(location)) {
            this.localCache.put(md, location);
        } else {
            this.globalCache.put(md, location);
        }
        return location;
    }

    void clearLocalScopes() {
        this.localCache.clear();
    }

    void importScope(MDBaseNode node, LLVMSourceLocation importedScope) {
        this.globalCache.put(node, importedScope);
    }

    private LazySourceSectionImpl buildSection(MDFile file, long startLine, long startCol) {
        if (file == null) {
            return null;
        }
        String relPath = MDString.getIfInstance(file.getFile());
        if (relPath == null || relPath.isEmpty()) {
            return null;
        }
        TruffleFile sourceFile = this.getSourceFile(file);
        return new LazySourceSectionImpl(this.sources, sourceFile, relPath, (int)startLine, (int)startCol);
    }

    private static Source asSource(Map<String, Source> sources, TruffleFile sourceFile, String path) {
        if (sources.containsKey(path)) {
            return sources.get(path);
        }
        if (path == null) {
            return null;
        }
        String mimeType = DIScopeBuilder.getMimeType(path);
        Source source = null;
        if (sourceFile != null) {
            Source.SourceBuilder builder = Source.newBuilder((String)"llvm", (TruffleFile)sourceFile).mimeType(mimeType);
            try {
                source = builder.build();
            }
            catch (IOException | SecurityException ex) {
                source = builder.content(Source.CONTENT_NONE).build();
            }
        } else {
            String sourceText = STDIN_FILENAME.equals(path) ? STDIN_SOURCE_TEXT : path;
            source = Source.newBuilder((String)"llvm", (CharSequence)sourceText, (String)sourceText).mimeType(MIMETYPE_UNAVAILABLE).build();
        }
        sources.put(path, source);
        return source;
    }

    private final class FileExtractor
    implements MetadataVisitor {
        private MDFile file;

        private FileExtractor() {
        }

        MDFile extractFile(MDBaseNode node) {
            this.file = null;
            node.accept(this);
            return this.file;
        }

        @Override
        public void visit(MDFile md) {
            this.file = md;
        }

        @Override
        public void visit(MDCompileUnit md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDBasicType md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDCompositeType md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDDerivedType md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDGlobalVariable md) {
            MDBaseNode fileRef = md.getFile() != MDVoidNode.INSTANCE ? md.getFile() : md.getCompileUnit();
            fileRef.accept(this);
        }

        @Override
        public void visit(MDLexicalBlock md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDLexicalBlockFile md) {
            MDBaseNode fileRef = md.getFile() != MDVoidNode.INSTANCE ? md.getFile() : md.getScope();
            fileRef.accept(this);
        }

        @Override
        public void visit(MDLocalVariable md) {
            MDBaseNode fileRef = md.getFile() != MDVoidNode.INSTANCE ? md.getFile() : md.getScope();
            fileRef.accept(this);
        }

        @Override
        public void visit(MDMacroFile md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDModule md) {
            md.getScope().accept(this);
        }

        @Override
        public void visit(MDNamespace md) {
            md.getFile().accept(this);
        }

        @Override
        public void visit(MDSubprogram md) {
            MDBaseNode fileRef = md.getFile() != MDVoidNode.INSTANCE ? md.getFile() : md.getCompileUnit();
            fileRef.accept(this);
        }

        @Override
        public void visit(MDLocation md) {
            md.getScope().accept(this);
        }

        @Override
        public void visit(MDGlobalVariableExpression md) {
            md.getGlobalVariable().accept(this);
        }

        @Override
        public void visit(MDString md) {
            MDCompositeType typeNode = DIScopeBuilder.this.metadata.identifyType(md.getString());
            if (typeNode != null) {
                typeNode.accept(this);
            }
        }

        @Override
        public void visit(MDCommonBlock md) {
            MDBaseNode fileRef = md.getFile() != MDVoidNode.INSTANCE ? md.getFile() : md.getScope();
            fileRef.accept(this);
        }

        @Override
        public void visit(MDLabel md) {
            MDBaseNode fileRef = md.getFile() != MDVoidNode.INSTANCE ? md.getFile() : md.getScope();
            fileRef.accept(this);
        }
    }

    private final class Builder
    implements MetadataVisitor {
        LLVMSourceLocation loc;
        private LLVMSourceLocation parent = null;
        private LLVMSourceLocation.Kind kind = LLVMSourceLocation.Kind.UNKNOWN;
        private String name = null;
        private LazySourceSectionImpl sourceSection = null;
        private MDFile file = null;
        private long line = -1L;
        private long col = -1L;

        private Builder() {
        }

        public LLVMSourceLocation build() {
            if (this.loc == null) {
                this.sourceSection = DIScopeBuilder.this.buildSection(this.file, this.line, this.col);
                this.loc = LLVMSourceLocation.create(this.parent, this.kind, this.name, this.sourceSection, null);
            }
            return this.loc;
        }

        @Override
        public void visit(MDLocation md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.LINE;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.line = md.getLine();
            this.col = md.getColumn();
        }

        @Override
        public void visit(MDLexicalBlock md) {
            this.parent = md.getScope() != MDVoidNode.INSTANCE ? DIScopeBuilder.this.buildLocation(md.getScope()) : DIScopeBuilder.this.buildLocation(md.getFile());
            this.kind = LLVMSourceLocation.Kind.BLOCK;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.line = md.getLine();
            this.col = md.getColumn();
        }

        @Override
        public void visit(MDLexicalBlockFile md) {
            this.parent = md.getScope() != MDVoidNode.INSTANCE ? DIScopeBuilder.this.buildLocation(md.getScope()) : DIScopeBuilder.this.buildLocation(md.getFile());
            this.kind = LLVMSourceLocation.Kind.BLOCK;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
        }

        @Override
        public void visit(MDSubprogram md) {
            this.parent = md.getScope() != MDVoidNode.INSTANCE ? DIScopeBuilder.this.buildLocation(md.getScope()) : DIScopeBuilder.this.buildLocation(md.getCompileUnit());
            this.kind = LLVMSourceLocation.Kind.FUNCTION;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.line = md.getLine();
            this.name = MDNameExtractor.getName(md.getName());
            LLVMSourceLocation compileUnit = DIScopeBuilder.this.buildLocation(md.getCompileUnit());
            this.sourceSection = DIScopeBuilder.this.buildSection(this.file, this.line, this.col);
            this.loc = LLVMSourceLocation.create(this.parent, this.kind, this.name, this.sourceSection, compileUnit);
        }

        @Override
        public void visit(MDNamespace md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.NAMESPACE;
            this.name = MDNameExtractor.getName(md.getName());
        }

        @Override
        public void visit(MDCompileUnit md) {
            this.kind = LLVMSourceLocation.Kind.COMPILEUNIT;
        }

        @Override
        public void visit(MDFile md) {
            this.kind = LLVMSourceLocation.Kind.FILE;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
        }

        @Override
        public void visit(MDModule md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.MODULE;
            this.name = MDNameExtractor.getName(md.getName());
        }

        @Override
        public void visit(MDCommonBlock md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.COMMON_BLOCK;
            this.name = MDNameExtractor.getName(md.getName());
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.line = md.getLine();
        }

        @Override
        public void visit(MDBasicType md) {
            this.kind = LLVMSourceLocation.Kind.TYPE;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.name = MDNameExtractor.getName(md.getName());
        }

        @Override
        public void visit(MDCompositeType md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.TYPE;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.name = MDNameExtractor.getName(md.getName());
            this.line = md.getLine();
        }

        @Override
        public void visit(MDDerivedType md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.TYPE;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.name = MDNameExtractor.getName(md.getName());
            this.line = md.getLine();
        }

        @Override
        public void visit(MDGlobalVariable md) {
            this.parent = md.getScope() != MDVoidNode.INSTANCE ? DIScopeBuilder.this.buildLocation(md.getScope()) : DIScopeBuilder.this.buildLocation(md.getCompileUnit());
            this.kind = LLVMSourceLocation.Kind.GLOBAL;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.name = MDNameExtractor.getName(md.getName());
            this.line = md.getLine();
        }

        @Override
        public void visit(MDLocalVariable md) {
            this.parent = DIScopeBuilder.this.buildLocation(md.getScope());
            this.kind = LLVMSourceLocation.Kind.LOCAL;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.name = MDNameExtractor.getName(md.getName());
            this.line = md.getLine();
        }

        @Override
        public void visit(MDString md) {
            MDCompositeType actualType = DIScopeBuilder.this.metadata.identifyType(md.getString());
            this.loc = DIScopeBuilder.this.buildLocation(actualType);
            DIScopeBuilder.this.globalCache.put(md, this.loc);
        }

        @Override
        public void visit(MDGlobalVariableExpression md) {
            MDBaseNode variable = md.getGlobalVariable();
            this.loc = DIScopeBuilder.this.buildLocation(variable);
            DIScopeBuilder.this.globalCache.put(md, this.loc);
        }

        @Override
        public void visit(MDLabel md) {
            MDBaseNode parentScopeNode = md.getScope() != MDVoidNode.INSTANCE ? md.getScope() : md.getFile();
            this.parent = DIScopeBuilder.this.buildLocation(parentScopeNode);
            this.kind = LLVMSourceLocation.Kind.LABEL;
            this.file = DIScopeBuilder.this.fileExtractor.extractFile(md);
            this.name = MDNameExtractor.getName(md.getName());
            this.line = md.getLine();
        }
    }

    private static final class LazySourceSectionImpl
    extends LLVMSourceLocation.LazySourceSection {
        private final TruffleFile sourceFile;
        private final String path;
        private final int line;
        private final int column;
        private final HashMap<String, Source> sources;

        LazySourceSectionImpl(HashMap<String, Source> sources, TruffleFile sourceFile, String path, int line, int column) {
            this.sources = sources;
            this.sourceFile = sourceFile;
            this.path = path;
            this.line = line;
            this.column = column;
        }

        @Override
        public SourceSection get() {
            SourceSection section;
            Source source = DIScopeBuilder.asSource(this.sources, this.sourceFile, this.path);
            if (source == null) {
                return null;
            }
            try {
                section = DIScopeBuilder.MIMETYPE_UNAVAILABLE.equals(source.getMimeType()) ? source.createUnavailableSection() : (this.line < 0 ? source.createSection(0, source.getLength()) : (this.line == 0 ? source.createSection(1) : (this.column <= 0 ? source.createSection(this.line) : source.createSection(this.line, this.column, this.line, this.column))));
            }
            catch (IllegalArgumentException ignored) {
                section = null;
            }
            return section;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getColumn() {
            return this.column;
        }
    }
}

