/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDValue;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.UndefinedConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.BigIntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VoidType;

public final class ParseUtil {
    private static final long DEFAULT_NUMBER = 0L;
    private static final long BYTE_MASK = 255L;

    public static boolean isInteger(long[] args, int index, Metadata md) {
        int typeIndex = index << 1;
        Type type = md.getTypeById(args[typeIndex]);
        if (type == MetaType.METADATA || VoidType.INSTANCE.equals(type)) {
            return false;
        }
        int valueIndex = typeIndex + 1;
        SymbolImpl value = (SymbolImpl)md.getScope().getSymbols().getOrNull((int)args[valueIndex]);
        return value instanceof IntegerConstant || value instanceof BigIntegerConstant || value instanceof NullConstant || value instanceof UndefinedConstant;
    }

    public static long asLong(long[] args, int index, Metadata md) {
        int typeIndex = index << 1;
        if (typeIndex >= args.length) {
            return 0L;
        }
        Type type = md.getTypeById(args[typeIndex]);
        if (type == MetaType.METADATA || VoidType.INSTANCE.equals(type)) {
            return 0L;
        }
        int valueIndex = typeIndex + 1;
        SymbolImpl value = (SymbolImpl)md.getScope().getSymbols().getOrNull((int)args[valueIndex]);
        if (value instanceof IntegerConstant) {
            return ((IntegerConstant)value).getValue();
        }
        if (value instanceof BigIntegerConstant) {
            return ((BigIntegerConstant)value).getValue().longValue();
        }
        if (value instanceof NullConstant || value instanceof UndefinedConstant) {
            return 0L;
        }
        return 0L;
    }

    public static int asInt(long[] args, int index, Metadata md) {
        return (int)ParseUtil.asLong(args, index, md);
    }

    static boolean asBoolean(long[] args, int index, Metadata md) {
        return ParseUtil.asLong(args, index, md) != 0L;
    }

    static MDBaseNode resolveReference(long[] args, int index, MDBaseNode dependent, Metadata md) {
        int typeIndex = index << 1;
        if (typeIndex >= args.length) {
            return MDVoidNode.INSTANCE;
        }
        int valueIndex = typeIndex + 1;
        Type type = md.getTypeById(args[typeIndex]);
        long value = args[valueIndex];
        if (type == MetaType.METADATA) {
            return md.getScope().getMetadata().getNonNullable(value, dependent);
        }
        if (type != VoidType.INSTANCE) {
            return MDValue.create(value, md.getScope());
        }
        return MDVoidNode.INSTANCE;
    }

    static MDBaseNode resolveSymbol(long[] args, int index, Metadata md) {
        int typeIndex = index << 1;
        if (typeIndex >= args.length) {
            return MDVoidNode.INSTANCE;
        }
        int valueIndex = typeIndex + 1;
        Type type = md.getTypeById(args[typeIndex]);
        long value = (int)args[valueIndex];
        if (type != MetaType.METADATA && !VoidType.INSTANCE.equals(type)) {
            return MDValue.create(value, md.getScope());
        }
        return MDVoidNode.INSTANCE;
    }

    public static String longArrayToString(int startIndex, long[] chars) {
        byte[] bytes = new byte[chars.length - startIndex];
        int from = startIndex;
        for (int to = 0; to < bytes.length; ++to) {
            bytes[to] = (byte)(chars[from] & 0xFFL);
            ++from;
        }
        return new String(bytes);
    }

    static long unrotateSign(long u) {
        return (u & 1L) == 1L ? u >> 1 ^ 0xFFFFFFFFFFFFFFFFL : u >> 1;
    }
}

