/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;

public abstract class MDType
extends MDName {
    private final DwarfTag tag;
    private final long size;
    private final long align;
    private final long offset;
    private final long line;
    private final long flags;
    private MDBaseNode file;

    MDType(long tag, long size, long align, long offset, long line, long flags) {
        this.tag = DwarfTag.decode(tag);
        this.size = size;
        this.align = align;
        this.offset = offset;
        this.line = line;
        this.flags = flags;
        this.file = MDVoidNode.INSTANCE;
    }

    public long getSize() {
        return this.size;
    }

    public long getAlign() {
        return this.align;
    }

    public long getOffset() {
        return this.offset;
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public long getLine() {
        return this.line;
    }

    public long getFlags() {
        return this.flags;
    }

    public DwarfTag getTag() {
        return this.tag;
    }

    public void setFile(MDBaseNode file) {
        this.file = file;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.file == oldValue) {
            this.file = newValue;
        }
    }

    public static enum DwarfTag {
        UNKNOWN(-1),
        DW_TAG_ARRAY_TYPE(1),
        DW_TAG_CLASS_TYPE(2),
        DW_TAG_ENUMERATION_TYPE(4),
        DW_TAG_FORMAL_PARAMETER(5),
        DW_TAG_MEMBER(13),
        DW_TAG_POINTER_TYPE(15),
        DW_TAG_REFERENCE_TYPE(16),
        DW_TAG_STRUCTURE_TYPE(19),
        DW_TAG_SUBROUTINE_TYPE(21),
        DW_TAG_TYPEDEF(22),
        DW_TAG_UNION_TYPE(23),
        DW_TAG_INHERITANCE(28),
        DW_TAG_PTR_TO_MEMBER_TYPE(31),
        DW_TAG_BASE_TYPE(36),
        DW_TAG_CONST_TYPE(38),
        DW_TAG_FRIEND(42),
        DW_TAG_VOLATILE_TYPE(53),
        DW_TAG_RESTRICT_TYPE(55),
        DW_TAG_UNSPECIFIED_TYPE(59),
        DW_TAG_ATOMIC_TYPE(71),
        DW_TAG_VECTOR_TYPE(259);

        private static final DwarfTag[] VALUES;
        private final int id;

        private DwarfTag(int id) {
            this.id = id;
        }

        static DwarfTag decode(long val) {
            for (DwarfTag tag : VALUES) {
                if ((long)tag.id != val) continue;
                return tag;
            }
            return UNKNOWN;
        }

        static {
            VALUES = DwarfTag.values();
        }
    }
}

