/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;

public final class ValueSymbolTable
implements ParserListener {
    private static final int VALUE_SYMTAB_ENTRY = 1;
    private static final int VALUE_SYMTAB_BASIC_BLOCK_ENTRY = 2;
    private static final int VALUE_SYMTAB_FUNCTION_ENTRY = 3;
    private final IRScope container;

    ValueSymbolTable(IRScope container) {
        this.container = container;
    }

    @Override
    public void record(RecordBuffer buffer) {
        int id = buffer.getId();
        int index = buffer.readInt();
        switch (id) {
            case 1: {
                this.container.nameSymbol(index, buffer.readString());
                break;
            }
            case 2: {
                this.container.nameBlock(index, buffer.readString());
                break;
            }
            case 3: {
                buffer.skip();
                this.container.nameSymbol(index, buffer.readString());
                break;
            }
        }
    }
}

