/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.listeners.Module;
import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.StringTable;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoModuleProcessor;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalValueSymbol;
import com.oracle.truffle.llvm.parser.scanner.Block;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.parser.text.LLSourceBuilder;
import com.oracle.truffle.llvm.parser.util.SymbolNameMangling;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.util.List;

public final class BCFileRoot
implements ParserListener {
    private final ModelModule module;
    private final StringTable stringTable;
    private final IRScope scope;
    private final LLSourceBuilder llSource;

    public BCFileRoot(ModelModule module, Source bcSource) {
        this.module = module;
        this.stringTable = new StringTable();
        this.scope = new IRScope();
        this.llSource = LLSourceBuilder.create(bcSource);
    }

    @Override
    public ParserListener enter(Block block) {
        switch (block) {
            case MODULE: {
                return new Module(this.module, this.stringTable, this.scope, this.llSource);
            }
            case STRTAB: {
                return this.stringTable;
            }
        }
        return ParserListener.DEFAULT;
    }

    public void exit(LLVMContext context) {
        int globalIndex = BCFileRoot.setMissingNames(this.module.getGlobalVariables(), 0);
        BCFileRoot.setMissingNames(this.module.getAliases(), globalIndex);
        SymbolNameMangling.demangleGlobals(this.module);
        DebugInfoModuleProcessor.processModule(this.module, this.scope.getMetadata(), context);
    }

    private static int setMissingNames(List<? extends GlobalValueSymbol> globals, int startIndex) {
        int globalIndex = startIndex;
        for (GlobalValueSymbol globalValueSymbol : globals) {
            if (!LLVMIdentifier.isUnknown(globalValueSymbol.getName())) continue;
            globalValueSymbol.setName(String.valueOf(globalIndex++));
        }
        return globalIndex;
    }

    @Override
    public void record(RecordBuffer buffer) {
    }
}

