/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm;

import com.oracle.truffle.llvm.NativeConfiguration;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.ConfigurationFactory;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.List;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionValues;

public final class NativeConfigurationFactory
implements ConfigurationFactory<Key> {
    @Override
    public Key parseOptions(OptionValues options) {
        return new Key(options);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public List<OptionDescriptor> getOptionDescriptors() {
        return SulongEngineOption.describeOptions();
    }

    @Override
    public Configuration createConfiguration(LLVMLanguage language, Key key) {
        return new NativeConfiguration(language, key);
    }

    public static final class Key {
        final boolean loadCxxLibraries;

        public Key(OptionValues options) {
            this.loadCxxLibraries = (Boolean)options.get(SulongEngineOption.LOAD_CXX_LIBRARIES);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return this.loadCxxLibraries == other.loadCxxLibraries;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.loadCxxLibraries ? 1 : 0);
            return hash;
        }
    }
}

