/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.exceptions;

import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsNode;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsViewSupport;
import org.graalvm.visualvm.jfr.views.exceptions.JFRSnapshotExceptionsViewProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class JFRSnapshotExceptionsView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/exception.png";
    private JFRModel model;
    private DataViewComponent dvc;
    private ExceptionsViewSupport.MasterViewSupport masterView;
    private ExceptionsViewSupport.DataViewSupport dataView;

    JFRSnapshotExceptionsView(JFRSnapshot jfrSnapshot) {
        super((DataSource)jfrSnapshot, "Exceptions", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 35, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
    }

    protected DataViewComponent createComponent() {
        this.masterView = new ExceptionsViewSupport.MasterViewSupport(this.model){

            @Override
            void firstShown() {
                this.changeAggregation(ExceptionsViewSupport.Aggregation.CLASS, ExceptionsViewSupport.Aggregation.NONE);
            }

            @Override
            void changeAggregation(ExceptionsViewSupport.Aggregation primary, ExceptionsViewSupport.Aggregation secondary) {
                JFRSnapshotExceptionsView.this.setAggregation(primary, secondary);
            }
        };
        boolean hasEvents = this.model != null && this.model.containsEvent(JFRSnapshotExceptionsViewProvider.EventChecker.class);
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
            this.dataView = new ExceptionsViewSupport.DataViewSupport();
            this.dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        }
        return this.dvc;
    }

    private void setAggregation(final ExceptionsViewSupport.Aggregation primary, final ExceptionsViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new ExceptionsNode.Root(), false);
        new RequestProcessor("JFR Exceptions Initializer").post(new Runnable(){

            @Override
            public void run() {
                final ExceptionsNode.Root root = new ExceptionsNode.Root(primary, secondary);
                JFRSnapshotExceptionsView.this.model.visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFRSnapshotExceptionsView.this.dataView.setData(root, !ExceptionsViewSupport.Aggregation.NONE.equals((Object)secondary));
                        JFRSnapshotExceptionsView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }
}

