/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.exceptions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsNode;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsRenderers;
import org.graalvm.visualvm.jfr.views.exceptions.JFRSnapshotExceptionsViewProvider;
import org.graalvm.visualvm.lib.ui.components.HTMLLabel;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

final class ExceptionsViewSupport {
    ExceptionsViewSupport() {
    }

    static final class DataViewSupport
    extends JPanel {
        private DataModel tableModel;
        private ProfilerTreeTable table;

        DataViewSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Data", null, 10, (JComponent)this, null);
        }

        void setData(ExceptionsNode root, boolean twoAggregations) {
            this.tableModel.setRoot((TreeNode)((Object)root));
            this.table.setShowsRootHandles(twoAggregations);
        }

        private void initComponents() {
            this.tableModel = new DataModel();
            this.table = new ProfilerTreeTable((ProfilerTreeTableModel)this.tableModel, true, true, new int[]{0});
            this.table.setRootVisible(false);
            this.table.setShowsRootHandles(true);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setSortColumn(1);
            this.table.setDefaultSortOrder(SortOrder.DESCENDING);
            this.table.setDefaultSortOrder(0, SortOrder.ASCENDING);
            ExceptionsRenderers.NameRenderer nameRenderer = new ExceptionsRenderers.NameRenderer();
            this.table.setTreeCellRenderer((ProfilerRenderer)nameRenderer);
            ExceptionsRenderers.CountRenderer countRenderer = new ExceptionsRenderers.CountRenderer();
            this.table.setColumnRenderer(1, (ProfilerRenderer)countRenderer);
            this.table.setDefaultColumnWidth(1, countRenderer.getPreferredWidth());
            this.table.setColumnVisibility(1, ExceptionsRenderers.CountRenderer.isInitiallyVisible());
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer((ProfilerTable)this.table, false, null), "Center");
        }

        private static class DataModel
        extends ProfilerTreeTableModel.Abstract {
            DataModel() {
                super((TreeNode)((Object)new ExceptionsNode.Root()));
            }

            public int getColumnCount() {
                return 2;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return JTree.class;
                    }
                }
                return Long.class;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return ExceptionsRenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return ExceptionsRenderers.CountRenderer.getDisplayName();
                    }
                }
                return null;
            }

            public Object getValueAt(TreeNode node, int column) {
                if (node == null) {
                    return null;
                }
                ExceptionsNode fnode = (ExceptionsNode)((Object)node);
                switch (column) {
                    case 0: {
                        return fnode;
                    }
                    case 1: {
                        return this.toLong(fnode.count);
                    }
                }
                return null;
            }

            public void setValueAt(Object o, TreeNode node, int column) {
            }

            public boolean isCellEditable(TreeNode node, int column) {
                return false;
            }

            private Long toLong(long value) {
                return value == 0L ? null : Long.valueOf(value);
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel {
        private Aggregation lastPrimary;
        private Aggregation lastSecondary;
        private int prefHeight = -1;
        private JLabel firstLabel;
        private JLabel secondLabel;
        private JComboBox firstCombo;
        private JComboBox secondCombo;
        private JButton updateButton;
        private HTMLLabel statusValueLabel;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("Exceptions", null, (JComponent)this);
        }

        abstract void firstShown();

        abstract void changeAggregation(Aggregation var1, Aggregation var2);

        void showProgress() {
            this.updateButton.setEnabled(false);
            this.updateButton.setVisible(false);
            this.statusValueLabel.setVisible(true);
        }

        void hideProgress() {
            this.statusValueLabel.setVisible(false);
            this.updateButton.setVisible(true);
        }

        private void handleAggregationChanged(boolean updateSecondary) {
            if (updateSecondary) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.secondCombo.getModel();
                while (model.getSize() > 1) {
                    model.removeElementAt(1);
                }
                if (!Aggregation.CLASS.equals(this.firstCombo.getSelectedItem()) && !Aggregation.CLASS_MESSAGE.equals(this.firstCombo.getSelectedItem())) {
                    model.addElement(Aggregation.CLASS);
                }
                if (!Aggregation.MESSAGE.equals(this.firstCombo.getSelectedItem()) && !Aggregation.CLASS_MESSAGE.equals(this.firstCombo.getSelectedItem())) {
                    model.addElement(Aggregation.MESSAGE);
                }
                if (!(Aggregation.CLASS.equals(this.firstCombo.getSelectedItem()) || Aggregation.MESSAGE.equals(this.firstCombo.getSelectedItem()) || Aggregation.CLASS_MESSAGE.equals(this.firstCombo.getSelectedItem()))) {
                    model.addElement(Aggregation.CLASS_MESSAGE);
                }
                if (!Aggregation.THREAD.equals(this.firstCombo.getSelectedItem())) {
                    model.addElement(Aggregation.THREAD);
                }
            }
            this.updateButton.setEnabled(this.lastPrimary != this.firstCombo.getSelectedItem() || this.lastSecondary != this.secondCombo.getSelectedItem());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            if (this.prefHeight == -1) {
                this.prefHeight = pref.height;
            } else {
                pref.height = this.prefHeight;
            }
            return pref;
        }

        private void initComponents(JFRModel model) {
            this.setOpaque(false);
            if (model == null) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else if (!model.containsEvent(JFRSnapshotExceptionsViewProvider.EventChecker.class)) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("Exceptions", JFRSnapshotExceptionsViewProvider.EventChecker.checkedTypes()), "Center");
            } else {
                this.setLayout(new GridBagLayout());
                this.setBorder(BorderFactory.createEmptyBorder(11, 5, 20, 5));
                this.firstLabel = new JLabel();
                this.firstLabel.setText("Aggregation:");
                this.firstLabel.setOpaque(false);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.firstLabel, constraints);
                this.firstCombo = new JComboBox<Object>(new Object[]{Aggregation.CLASS, Aggregation.MESSAGE, Aggregation.CLASS_MESSAGE, Aggregation.THREAD});
                this.firstCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleAggregationChanged(true);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 1;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.firstCombo, constraints);
                this.secondLabel = new JLabel();
                this.secondLabel.setText("secondary:");
                this.secondLabel.setOpaque(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 2;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)this.secondLabel, constraints);
                this.secondCombo = new JComboBox<Object>(new Object[]{Aggregation.NONE, Aggregation.MESSAGE, Aggregation.THREAD});
                this.secondCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleAggregationChanged(false);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 3;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.secondCombo, constraints);
                this.lastPrimary = (Aggregation)((Object)this.firstCombo.getSelectedItem());
                this.lastSecondary = (Aggregation)((Object)this.secondCombo.getSelectedItem());
                JSeparator updateSeparator = new JSeparator(1);
                updateSeparator.setOpaque(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 4;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 16, 0, 0);
                this.add((Component)updateSeparator, constraints);
                this.updateButton = new JButton("Update Data");
                this.updateButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        updateButton.setEnabled(false);
                        lastPrimary = (Aggregation)((Object)firstCombo.getSelectedItem());
                        lastSecondary = (Aggregation)((Object)secondCombo.getSelectedItem());
                        this.changeAggregation((Aggregation)((Object)firstCombo.getSelectedItem()), (Aggregation)((Object)secondCombo.getSelectedItem()));
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 5;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)this.updateButton, constraints);
                this.statusValueLabel = new HTMLLabel("<nobr><b>Progress:</b> reading data...</nobr>");
                constraints = new GridBagConstraints();
                constraints.gridx = 6;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 20, 0, 0);
                this.add((Component)this.statusValueLabel, constraints);
                this.statusValueLabel.setVisible(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 7;
                constraints.gridy = 2;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.gridwidth = 0;
                constraints.fill = 1;
                constraints.anchor = 18;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)Spacer.create(), constraints);
                Dimension cpuD = this.firstCombo.getPreferredSize();
                Dimension memoryD = this.secondCombo.getPreferredSize();
                Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
                this.firstCombo.setPreferredSize(maxD);
                this.firstCombo.setMinimumSize(maxD);
                this.secondCombo.setPreferredSize(maxD);
                this.secondCombo.setMinimumSize(maxD);
                Dimension sepD = updateSeparator.getPreferredSize();
                sepD.height = maxD.height - 2;
                sepD.width = 5;
                updateSeparator.setPreferredSize(sepD);
                updateSeparator.setMinimumSize(sepD);
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    static enum Aggregation {
        NONE{

            public String toString() {
                return "None";
            }
        }
        ,
        CLASS{

            public String toString() {
                return "Class";
            }
        }
        ,
        MESSAGE{

            public String toString() {
                return "Message";
            }
        }
        ,
        CLASS_MESSAGE{

            public String toString() {
                return "Class : Message";
            }
        }
        ,
        THREAD{

            public String toString() {
                return "Thread";
            }
        };

    }
}

